/*
 * nrf_info_served_bsf_info_value.h
 *
 * 
 */

#ifndef _OpenAPI_nrf_info_served_bsf_info_value_H_
#define _OpenAPI_nrf_info_served_bsf_info_value_H_

#include <string.h>
#include "../external/cJSON.h"
#include "../include/list.h"
#include "../include/keyValuePair.h"
#include "../include/binary.h"
#include "bsf_info.h"
#include "identity_range.h"
#include "ipv4_address_range.h"
#include "ipv6_prefix_range.h"
#include "supi_range.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct OpenAPI_nrf_info_served_bsf_info_value_s OpenAPI_nrf_info_served_bsf_info_value_t;
typedef struct OpenAPI_nrf_info_served_bsf_info_value_s {
    OpenAPI_list_t *dnn_list;
    OpenAPI_list_t *ip_domain_list;
    OpenAPI_list_t *ipv4_address_ranges;
    OpenAPI_list_t *ipv6_prefix_ranges;
    char *rx_diam_host;
    char *rx_diam_realm;
    char *group_id;
    OpenAPI_list_t *supi_ranges;
    OpenAPI_list_t *gpsi_ranges;
} OpenAPI_nrf_info_served_bsf_info_value_t;

OpenAPI_nrf_info_served_bsf_info_value_t *OpenAPI_nrf_info_served_bsf_info_value_create(
    OpenAPI_list_t *dnn_list,
    OpenAPI_list_t *ip_domain_list,
    OpenAPI_list_t *ipv4_address_ranges,
    OpenAPI_list_t *ipv6_prefix_ranges,
    char *rx_diam_host,
    char *rx_diam_realm,
    char *group_id,
    OpenAPI_list_t *supi_ranges,
    OpenAPI_list_t *gpsi_ranges
);
void OpenAPI_nrf_info_served_bsf_info_value_free(OpenAPI_nrf_info_served_bsf_info_value_t *nrf_info_served_bsf_info_value);
OpenAPI_nrf_info_served_bsf_info_value_t *OpenAPI_nrf_info_served_bsf_info_value_parseFromJSON(cJSON *nrf_info_served_bsf_info_valueJSON);
cJSON *OpenAPI_nrf_info_served_bsf_info_value_convertToJSON(OpenAPI_nrf_info_served_bsf_info_value_t *nrf_info_served_bsf_info_value);
OpenAPI_nrf_info_served_bsf_info_value_t *OpenAPI_nrf_info_served_bsf_info_value_copy(OpenAPI_nrf_info_served_bsf_info_value_t *dst, OpenAPI_nrf_info_served_bsf_info_value_t *src);

#ifdef __cplusplus
}
#endif

#endif /* _OpenAPI_nrf_info_served_bsf_info_value_H_ */

