/*
 * Copyright (C) 2016 Andreas Steffen
 * HSR Hochschule fuer Technik Rapperswil
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 */

#include "test_suite.h"

#include <newhope_noise.h>

#include <library.h>

static const uint16_t n = 1024;
static const uint16_t q = 12289;

static const size_t seed_len = 32;

typedef struct {
	uint8_t key;
	uint8_t nonce;
	uint8_t uniform[64];
	uint32_t poly[1024];
} noise_t;

static noise_t noises[] = {
	{ 0x00, 0x00,	/* polynomial s */
	  { 0x9f, 0x07, 0xe7, 0xbe, 0x55, 0x51, 0x38, 0x7a, 0x98, 0xba,
		0x97, 0x7c, 0x73, 0x2d, 0x08, 0x0d, 0xcb, 0x0f, 0x29, 0xa0,
		0x48, 0xe3, 0x65, 0x69, 0x12, 0xc6, 0x53, 0x3e, 0x32, 0xee,
		0x7a, 0xed, 0x29, 0xb7, 0x21, 0x76, 0x9c, 0xe6, 0x4e, 0x43,
		0xd5, 0x71, 0x33, 0xb0, 0x74, 0xd8, 0x39, 0xd5, 0x31, 0xed,
		0x1f, 0x28, 0x51, 0x0a, 0xfb, 0x45, 0xac, 0xe1, 0x0a, 0x1f,
		0x4b, 0x79, 0x4d, 0x6f },
	  { 12286, 12288, 12287,     5,     4, 12288, 12286, 12287,     2,     2,
		    2, 12288,     2, 12284,     1, 12288, 12288, 12288,     6, 12288,
		    0,     4,     1, 12285, 12286,     2, 12284, 12287,     1,     5,
		    5, 12286, 12288,     2, 12286,     0,     3,     1,     0,     2,
		    0,     0,     4, 12283, 12284,     4,     0, 12288,     3, 12288,
		    0,     4,     1, 12288, 12286,     0,     3,     1, 12286, 12287,
		12285,     3,     2,     3, 12286,     0,     6,     6, 12288, 12284,
		    0, 12282,     1,     0,     4,     1,     0,     3,     2,     2,
		    3,     3,     2, 12288,     3,     1, 12287, 12285,     0, 12288,
		    0,     0, 12288, 12287, 12284, 12286,     0, 12288,     4,     4,
		12288,     5, 12286,     2, 12288,     5,     1, 12283,     1, 12288,
		    1, 12288, 12287, 12285,     2,     2, 12285, 12284,     0, 12285,
		12287,     0,     1,     0,     2, 12288, 12288, 12287,     0,     4,
		12288, 12285, 12288,     0,     2,     1, 12287,     3,     1,     3,
		    5, 12286,     1,     0, 12286,     0,     4,     0, 12288,     1,
		12288,     4,     5, 12283, 12288,     1,     3, 12283, 12286,     5,
		    1, 12286, 12287, 12286,     0, 12287, 12285,     1,     0,     0,
		    1,     3,     0,     0,     0, 12284, 12286,     2,     4, 12288,
		    6,     1,     2, 12288,     1, 12287, 12286, 12284, 12287,     1,
		    3, 12284,     0,     0,     6, 12286,     7,     5,     2,     3,
		12285, 12287, 12285,     2,     3, 12283,     2, 12284, 12288,     3,
		12288,     1,     4, 12287,     2, 12288, 12288,     1, 12286, 12284,
		    2,     1,     5, 12286,     0, 12288,     0,     0,     0, 12287,
		    1,     0,     3,     0,     0,     6,     2, 12283,     1,     3,
		    3, 12284,     3,     1, 12286,     2, 12288,     0,     6,     1,
		    1, 12285, 12287, 12288,     4,     2, 12288,     3, 12286, 12288,
		12287,     3,     3,     2,     7,     4, 12287, 12286, 12287,     2,
		    2, 12287,     1, 12288,     1, 12287, 12283, 12287, 12288,     1,
		12283,     0, 12286, 12288,     4, 12287, 12286, 12286,     2,     2,
		12287,     5, 12288,     4,     0, 12287,     1,     3, 12286,     2,
		    1,     1, 12288, 12287,     5, 12288,     0,     0,     1,     0,
		12286,     6,     2,     1,     2,     5, 12286,     6, 12286, 12288,
		    0, 12286,     3, 12283, 12288, 12284,     0,     7,     2,     6,
		    1, 12288, 12285, 12284,     1,     0,     0,     2, 12288, 12288,
		12288,     3,     3,     1,     3, 12286,     4,     3, 12284,     4,
		    1, 12287, 12287, 12285,     0, 12287, 12287, 12287, 12286, 12288,
		    1, 12287,     1,     0, 12288,     2,     0,     4,     0, 12287,
		12285, 12285,     5,     3, 12282,     0, 12287,     5, 12287,     1,
		12283, 12288, 12288,     3,     1,     1,     3, 12288, 12283,     5,
		12288, 12288,     5,     5,     1, 12286, 12286, 12288,     1,     2,
		    1,     3, 12287, 12288, 12284, 12287,     1, 12287,     0, 12286,
		12285,     1, 12287, 12282, 12286, 12287,     0, 12285,     4,     2,
		    1, 12282,     0,     1, 12288, 12285, 12284, 12286, 12286, 12287,
		12288,     1, 12288,     4, 12287,     4, 12287, 12287,     0,     1,
		12287,     3,     1, 12286, 12286,     4,     6, 12288,     1, 12285,
		12286, 12287,     0, 12287, 12287,     1, 12286,     5,     0,     2,
		12283, 12284,     1, 12286,     0, 12287, 12286, 12288,     1,     4,
		    4, 12283,     2,     6,     1, 12288, 12286,     2,     7,     2,
		    1, 12288,     5, 12284, 12288, 12288,     1,     7,     3, 12283,
		    1, 12286,     2, 12288, 12287,     1, 12286,     1, 12286, 12288,
		12287,     3,     2,     2,     0, 12284, 12287,     1,     1, 12284,
		12286,     1,     2,     1,     0, 12285,     1,     0,     1,     2,
		    2,     4, 12288,     1, 12288,     5,     0, 12287, 12288,     2,
		    0, 12288, 12287,     0, 12288, 12288,     0,     0, 12285,     4,
		    2, 12288,     0,     2,     0, 12288,     1,     3, 12287, 12288,
		12288, 12288, 12286,     0, 12285, 12286, 12287,     3,     0, 12286,
		    2,     1, 12285,     2, 12288,     0,     5,     0,     1, 12288,
		12288,     4,     3,     3, 12286,     2, 12288,     4, 12288,     6,
		    2, 12286,     4, 12287,     2, 12287,     0, 12284, 12288,     0,
		12286, 12288,     3,     4, 12286, 12288,     1,     3, 12286,     3,
		    4,     1,     1,     6,     3,     1,     1,     0, 12288,     4,
		    0, 12288,     0,     0,     0, 12288,     2,     4,     2, 12287,
		    0,     0,     3,     2,     3,     4,     0,     3,     2, 12288,
		    2,     4,     6, 12286, 12284, 12287,     1,     0,     0,     4,
		    1,     3, 12282,     1,     2,     2,     0,     3, 12282,     2,
		12287,     2, 12288,     4, 12288,     3,     3, 12283, 12288, 12288,
		12286, 12287,     5,     4,     3,     3, 12288, 12284,     2,     2,
		    0, 12288,     1,     3,     3,     4, 12284, 12288,     0,     1,
		12284,     0, 12286, 12287,     0,     0, 12287,     0,     1,     6,
		12288,     1, 12284, 12287, 12282, 12288,     4, 12287,     1, 12286,
		    1, 12286, 12286,     1,     4,     0, 12288,     1, 12288,     1,
		12285,     3,     1,     0,     1,     0, 12288, 12287,     2,     2,
		    0, 12288,     3, 12284,     2, 12288, 12288, 12288, 12287,     3,
		    3,     0, 12286, 12286,     1,     2, 12286, 12287,     0,     1,
		12288, 12287, 12287, 12288, 12288,     1,     9,     1, 12288, 12287,
		    2,     1,     1,     0, 12287, 12287,     2,     2, 12288, 12285,
		    1, 12287,     4,     0,     2,     1,     1,     3, 12284, 12286,
		    1,     2, 12288, 12287,     4,     1, 12285,     0,     1,     2,
		12288,     1,     3,     0, 12286,     0, 12288, 12286, 12287, 12286,
		    1, 12284,     1,     2,     2, 12288,     0, 12288,     1, 12284,
		    2,     3, 12287,     1, 12285, 12288,     0,     1, 12284,     2,
		12288, 12286, 12286,     3, 12288, 12282,     3, 12287, 12288, 12287,
		    4, 12287,     1,     2,     9, 12283, 12286, 12286,     0,     4,
		12288, 12288,     4,     0,     1,     1,     2, 12284,     1,     1,
		    0, 12288,     1,     0, 12287,     1,     1,     5,     2,     1,
		12288,     3, 12287,     5,     4,     1,     4, 12287, 12285,     3,
		12286,     1,     3,     0, 12287,     0, 12286, 12287, 12287, 12287,
		    3,     2, 12286, 12284,     2, 12288,     1,     1, 12288,     3,
		    1,     3, 12284,     3, 12282, 12288,     3,     0,     2, 12288,
		    0,     5,     0,     2,     0, 12281, 12285,     4,     3,     4,
		    2, 12284,     0,     0,     2,     2, 12287, 12284,     2, 12286,
		    1, 12288,     1, 12286, 12286, 12287,     4,     0,     6,     3,
		    0,     3, 12288, 12288, 12288, 12287,     3,     1,     1,     1,
		    2, 12287, 12284,     3, 12286, 12280,     3, 12284, 12287, 12288,
		    5, 12288, 12284,     2, 12285,     4,     3, 12286,     6,     2,
		    1, 12287,     0,     1,     2, 12286,     1,     0, 12287,     0,
		    1,     1, 12286,     2, 12285,     0,     1, 12288,     0,     1,
		12288,     1, 12288, 12287, 12287, 12285, 12282, 12288,     2, 12288,
		    2, 12284,     1, 12284, 12287, 12286, 12288,     0, 12288,     1,
		12283, 12286,     5,     3,     0, 12286, 12286,     3,     1,     0,
		    1, 12288, 12288,     4,     1, 12286, 12287, 12285,     2,     0,
		    2, 12287,     1, 12285, 12288, 12286, 12288,     2,     2, 12285,
		    3, 12286, 12285, 12287 }
	},
	{ 0x00, 0x01,	/* polynomial e */
	  { 0x46, 0xf0, 0xf6, 0xef, 0xee, 0x15, 0xc8, 0xf1, 0xb1, 0x98,
		0xcb, 0x49, 0xd9, 0x2b, 0x99, 0x08, 0x67, 0x90, 0x51, 0x59,
		0x44, 0x0c, 0xc7, 0x23, 0x91, 0x6d, 0xc0, 0x01, 0x28, 0x26,
		0x98, 0x10, 0x39, 0xce, 0x17, 0x66, 0xaa, 0x25, 0x42, 0xb0,
		0x5d, 0xb3, 0xbd, 0x80, 0x9a, 0xb1, 0x42, 0x48, 0x9d, 0x5d,
		0xbf, 0xe1, 0x27, 0x3e, 0x73, 0x99, 0x63, 0x7b, 0x4b, 0x32,
		0x13, 0x76, 0x8a, 0xaa },
	  { 12283,     1, 12288,     4,     0, 12285,     5,     1,     1,     2,
		    3,     4, 12288,     0,     3,     1,     1,     0, 12286,     6,
		    1,     0,     1,     0,     4,     2, 12288,     3,     0,     5,
		    1,     5,     2, 12285,     4, 12288,     3,     2, 12288,     2,
		12288, 12285, 12287,     6, 12282,     1, 12286,     7, 12287,     4,
		    2,     2, 12288, 12285,     0,     2,     0, 12288,     1, 12287,
		12287,     2,     1,     2,     1, 12285, 12288, 12286,     1,     2,
		12287, 12288, 12288,     1,     0, 12287,     0,     4,     2,     6,
		12287, 12285, 12283, 12285,     5, 12283, 12286,     1, 12283,     2,
		    3, 12286, 12285,     2,     5, 12286,     3,     0,     3, 12286,
		    5, 12285, 12287, 12288,     1,     5,     3,     5,     1,     1,
		    1, 12288,     5,     0, 12288,     3,     2, 12288, 12285, 12288,
		    5,     6,     0,     2,     1, 12287, 12288, 12287,     3, 12284,
		    2,     0,     3,     0,     0, 12288,     0,     2,     2,     2,
		    0,     1,     2,     2,     0,     0, 12287, 12285,     0,     4,
		    1, 12283,     3,     5, 12288, 12286, 12287,     6,     2,     0,
		    0, 12287,     2,     2, 12288,     0,     2, 12288, 12287, 12288,
		12288,     1, 12288,     1, 12288,     2,     4,     2,     1,     1,
		    0, 12287,     3,     2,     6,     2,     1, 12288, 12285,     6,
		    0,     1, 12284, 12287, 12287, 12286,     5,     4,     0,     5,
		12287, 12286, 12288, 12286,     0,     3,     1, 12287, 12287, 12288,
		12288, 12286,     1,     0,     3, 12287,     3,     1, 12283,     1,
		12288,     5,     1,     4, 12286, 12287,     2,     0,     0,     0,
		12281, 12286,     0,     8,     5,     0,     4,     0, 12287,     5,
		    1,     3,     2, 12286, 12286, 12288, 12285, 12285, 12287,     0,
		12284, 12287,     1,     0,     2,     1, 12286, 12288,     2, 12285,
		    0,     0,     0,     1,     0,     6,     1, 12288, 12287, 12287,
		    0,     3, 12288, 12288, 12287,     0, 12287,     1,     3,     0,
		    0, 12286, 12286,     4,     4, 12287,     1,     3,     4, 12287,
		12284,     2, 12288, 12286, 12283, 12285,     1,     3,     1, 12288,
		    0,     3,     3, 12284, 12285,     5,     3, 12288,     3,     4,
		    3,     1, 12288,     0, 12288,     1,     0,     0,     3,     0,
		    3,     2, 12287, 12288,     0, 12288,     0,     2, 12285,     4,
		    0, 12287, 12287,     1,     1,     1, 12287, 12285,     4, 12282,
		    3,     1,     1, 12288,     2,     4, 12285, 12286,     3,     1,
		    0, 12287, 12283, 12285,     2,     5,     1,     1, 12288, 12288,
		    0,     8,     3, 12287, 12285, 12287, 12286, 12284,     1, 12286,
		    1, 12288,     2,     3, 12288, 12288,     2, 12288, 12284, 12285,
		    0,     3, 12288, 12288,     2,     3,     7, 12287,     3,     3,
		    3, 12284,     0,     0,     1, 12283,     5,     0,     1, 12288,
		    3, 12286, 12287, 12286,     0,     0, 12287, 12283,     4, 12283,
		    0,     0,     3, 12285,     5, 12286, 12282, 12288,     1, 12287,
		12288,     1,     5,     2, 12287,     2, 12288,     7, 12288,     3,
		    5,     1,     0, 12287,     1, 12287,     3,     2,     4,     2,
		12287, 12286, 12288,     2,     5,     1, 12286,     4,     0,     2,
		    6, 12286,     2, 12286,     3, 12288,     5, 12285,     0,     2,
		12287,     5, 12286, 12284,     7, 12285, 12286, 12284, 12287,     1,
		12288, 12284, 12286,     2,     4,     2,     2, 12283, 12286,     2,
		    2, 12283,     1, 12286,     1,     0, 12284,     3,     0,     4,
		    1,     0,     4, 12288,     0, 12287, 12287, 12287, 12286, 12284,
		12288,     3,     1, 12285,     0,     3,     8,     4,     2, 12288,
		    3, 12287, 12287,     2,     3, 12288, 12286,     2, 12286, 12288,
		    0,     1, 12287, 12285,     0, 12285, 12288, 12287,     1, 12287,
		    0, 12284,     0,     1,     1, 12285,     0,     0,     0, 12287,
		12287,     3,     0,     4, 12288,     1, 12288, 12285, 12283,     0,
		12286, 12286, 12285, 12285, 12287,     1,     0,     2,     3,     1,
		    2, 12286, 12288,     3, 12286, 12288, 12288,     6,     2,     2,
		    0, 12288,     2,     5, 12288,     0, 12284, 12282, 12286,     1,
		12288, 12288, 12286, 12288,     3, 12286,     2,     0, 12283,     0,
		    4,     2, 12288,     0, 12286,     0,     4,     3, 12286, 12287,
		    4, 12288,     3,     2, 12283,     1,     1,     1,     3, 12286,
		    4,     0, 12288, 12285, 12287,     0,     0, 12286,     4,     0,
		12286,     2, 12288, 12288, 12285, 12283,     5,     3, 12286, 12288,
		    4,     1, 12283,     0, 12288,     0, 12287, 12287,     0,     3,
		12287, 12287,     2,     2,     3,     0,     1,     4, 12288,     3,
		    3,     0, 12284, 12285,     4, 12288,     1, 12287,     0,     1,
		12283,     1, 12284, 12287, 12286, 12285,     0,     0,     3, 12285,
		    3,     1, 12288, 12287, 12284, 12282,     5,     3,     3,     2,
		12285,     4, 12288,     0,     3, 12288,     4,     0, 12283, 12288,
		    2, 12285, 12288, 12282,     0,     2, 12285,     3,     1, 12284,
		    1,     5,     7, 12286,     5, 12285,     1,     2,     0,     4,
		12283, 12287, 12286,     2, 12280, 12287, 12288,     2, 12285, 12286,
		    2,     1,     2,     1,     2,     2,     3,     3,     0,     0,
		    4,     2, 12288, 12286,     4,     0,     1, 12288,     2, 12287,
		12288, 12288,     1,     3, 12283, 12288,     1, 12287,     1,     1,
		    3, 12288, 12288,     1,     2,     1,     1, 12283,     7, 12286,
		12288,     1, 12288, 12287, 12284,     7,     2, 12285, 12286,     0,
		    0,     0,     2,     4, 12288,     0, 12284, 12285, 12286,     2,
		12284,     2,     4,     6,     3, 12287, 12288, 12285,     1,     2,
		12286,     0,     0, 12287, 12288,     0, 12286,     2,     1,     1,
		    1,     3,     1, 12285,     4,     0, 12287, 12288, 12287,     0,
		12288, 12287, 12288, 12287, 12288, 12288,     0, 12287, 12284,     0,
		12288, 12285,     3,     2,     4,     2, 12284,     3,     1,     3,
		    4, 12288, 12285, 12284, 12287,     1,     4,     0,     2, 12288,
		    4, 12288, 12287,     3,     1,     0,     0, 12284, 12287,     2,
		    4, 12287,     2, 12288,     0,     2,     2,     3, 12287, 12286,
		    8, 12286, 12285,     0, 12285,     2,     3,     5, 12287, 12288,
		    6, 12288, 12284,     0,     0,     3,     1,     2, 12284,     2,
		    1,     3,     2,     0,     0, 12288, 12287, 12288,     1, 12288,
		    4,     3, 12284,     1,     3, 12288, 12283, 12288,     1,     1,
		    2,     1,     1,     3,     1, 12288,     0, 12288,     2,     0,
		    0, 12284, 12283,     3, 12288,     0,     2, 12287,     0,     0,
		12286, 12286,     0,     0,     2,     4, 12288,     1,     2,     3,
		    2, 12286, 12286,     1,     2,     4, 12288, 12288, 12284, 12287,
		    6,     2, 12288, 12286,     0,     0,     3, 12286, 12288, 12287,
		12286, 12287,     3,     1, 12286,     0,     4,     3, 12286,     5,
		    2,     1, 12287, 12286,     4, 12287,     0,     5, 12288,     0,
		12288,     2,     2,     1,     1,     0,     0, 12288, 12288, 12288,
		    0,     0, 12288, 12287,     5,     1, 12288,     1,    10,     1,
		    0,     0,     2,     2,     2,     0, 12288,     4,     2, 12283,
		    3,     1,     1, 12285,     2, 12285,     5,     7,     5, 12288,
		    0, 12287,     5,     1, 12288, 12286, 12287,     0,     0,     0,
		12287,     1,     3, 12288 }
	},
	{ 0x01, 0x00,	/* polynomial s' */
	  { 0x3a, 0xeb, 0x52, 0x24, 0xec, 0xf8, 0x49, 0x92, 0x9b, 0x9d,
		0x82, 0x8d, 0xb1, 0xce, 0xd4, 0xdd, 0x83, 0x20, 0x25, 0xe8,
		0x01, 0x8b, 0x81, 0x60, 0xb8, 0x22, 0x84, 0xf3, 0xc9, 0x49,
		0xaa, 0x5a, 0x8e, 0xca, 0x00, 0xbb, 0xb4, 0xa7, 0x3b, 0xda,
		0xd1, 0x92, 0xb5, 0xc4, 0x2f, 0x73, 0xf2, 0xfd, 0x4e, 0x27,
		0x36, 0x44, 0xc8, 0xb3, 0x61, 0x25, 0xa6, 0x4a, 0xdd, 0xeb,
		0x00, 0x6c, 0x13, 0xa0 },
	  {     5,     4,     4, 12288, 12286,     1, 12287, 12288,     2, 12288,
		12288, 12287,     2,     2, 12284, 12288, 12288,     3,     2,     3,
		12287,     2,     2,     0,     0,     2,     5, 12285,     5, 12287,
		    2, 12282, 12286,     2,     1,     2,     1,     1, 12288, 12285,
		12287, 12286,     2,     0,     0, 12285,     0,     0, 12287, 12286,
		12285, 12286,     2, 12288, 12288,     0,     1,     2, 12286,     2,
		    1,     0,     0,     2,     1, 12288,     1, 12287,     1,     0,
		    0,     2, 12285,     2,     2, 12288, 12286,     3, 12287,     0,
		    1,     1,     0,     2, 12287,     2,     1,     2,     3,     0,
		    0,     1, 12288, 12288,     2, 12287, 12286, 12286,     6, 12288,
		    0,     0,     4,     0, 12286,     0,     4, 12288, 12288,     5,
		12287, 12288, 12285,     2, 12285, 12288,     1,     0,     2, 12288,
		12286,     1,     3, 12285,     2,     2,     1,     1, 12288, 12288,
		12287,     1, 12288,     3,     0, 12285,     4, 12285, 12287,     2,
		    2, 12287, 12287, 12286, 12288, 12284,     2, 12286,     4,     1,
		    0, 12286, 12284,     3, 12286,     3, 12286,     3,     4,     1,
		12288, 12282,     2,     2, 12284,     0, 12286, 12283,     3,     0,
		    4,     2,     4,     2, 12285,    10, 12288,     8,     3,     2,
		    2,     0,     1,     0,     0, 12286,     2, 12284,     4,     1,
		12287, 12287,     1,     1, 12286,     1,     0, 12285, 12288, 12286,
		12287,     2,     1, 12284, 12288, 12285, 12285,     3,     0,     1,
		    4,     4,     1,     0,     2,     1, 12288,     1, 12287,     0,
		12286,     4,     2,     3,     3, 12285, 12288, 12288,     5,     2,
		    0,     4,     3, 12287, 12287,     5,     2,     3, 12284,     0,
		    8,     1,     1,     0,     5, 12288, 12288, 12288, 12286,     6,
		    3, 12288, 12286, 12287,     4, 12288,     2, 12288, 12284, 12287,
		    4, 12288,     0,     0,     3,     0,     4,     4, 12287,     0,
		    3,     0, 12285, 12287, 12288, 12288,     0,     0, 12287, 12288,
		12286,     0,     0, 12285, 12288,     4, 12287,     1,     2, 12288,
		12285,     5,     4, 12283,     2,     0, 12288,     2,     0,     0,
		12286, 12284,     3,     3,     3, 12287,     1,     1,     0,     1,
		    3, 12288,     4,     4,     0,     2,     0,     1, 12286, 12284,
		    2,     2, 12287,     3,     2, 12288,     3, 12286,     2, 12286,
		12288,     4,     3, 12288,     2, 12288,     2,     1, 12288, 12288,
		    7, 12288, 12288,     0, 12288,     1, 12284, 12288, 12288, 12287,
		12287,     1, 12285, 12287, 12287,     1,     0,     2, 12286,     3,
		12288, 12288, 12287,     3,     5,     0,     0, 12287,     2, 12287,
		12288,     8, 12287,     1,     2, 12288, 12284,     3,     0, 12287,
		12284,     3,     0,     2,     1,     3,     4, 12287, 12286, 12288,
		12286,     0,     0, 12287, 12285,     0, 12286,     2,     1, 12287,
		12288,     5, 12287, 12287, 12286,     2, 12283,     0,     0, 12286,
		    2, 12284,     5,     0,     1, 12287,     0,     3,     1, 12285,
		12288,     0,     3, 12287,     2, 12286,     0,     1, 12288,     1,
		12284, 12281, 12284, 12288, 12285,     2,     5,     4, 12286,     0,
		12287, 12288, 12286, 12285,     3, 12282,     1, 12287,     2,     0,
		    6, 12288,     4, 12286,     3, 12288, 12286, 12284,     3,     1,
		    6,     3,     2,     1,     2,     1,     1, 12288, 12287,     1,
		    3,     3,     1,     0,     0, 12288,     3, 12284, 12285, 12284,
		    1,     3, 12286,     0,     1, 12285, 12287,     1, 12285,     2,
		    0,     1, 12287,     1,     4,     3,     1, 12287,     0,     5,
		    1, 12288,     2,     1,     1,     4,     3, 12286,     3,     3,
		    2, 12287,     3, 12286,     0, 12288, 12285,     2,     3, 12286,
		    0, 12287,     5,     4,     1,     1, 12287, 12288,     2,     0,
		    0,     0,     2,     0, 12286,     4, 12288, 12288, 12285, 12286,
		    2, 12288, 12288,     0, 12288, 12286, 12284, 12287,     1,     5,
		    0, 12285, 12287,     2,     4,     3, 12285, 12287, 12288,     0,
		12288, 12287, 12286,     2, 12288, 12286, 12284,     1,     2, 12287,
		    4,     1,     4,     4, 12284,     2,     0, 12288,     3,     1,
		    0,     4,     1,     6,     0, 12286, 12288, 12287, 12287,     0,
		12284, 12285,     2, 12286,     1,     0,     3, 12288,     1,     2,
		12284, 12286, 12285, 12283, 12285,     0, 12285,     2,     0,     2,
		    1,     3,     1, 12286, 12288,     1,     4,     0,     0, 12287,
		12287, 12286,     0,     1, 12286,     0,     2, 12288,     2, 12287,
		    0,     0, 12286, 12287,     4,     6, 12286,     0, 12288,     0,
		    0, 12287,     2,     3,     4,     1,     3, 12286,     4,     0,
		12288, 12286, 12287, 12287, 12288,     4, 12285,     1, 12286, 12286,
		    2, 12288,     0,     0,     1,     5, 12285,     1, 12281,     3,
		12281,     2,     3,     0, 12284, 12288,     5,     0,     0, 12288,
		    0,     0, 12288, 12286,     3, 12287,     0,     2, 12288,     0,
		    3, 12288, 12286,     0, 12286, 12287, 12284,     0, 12286,     1,
		12287, 12282, 12287, 12288,     0,     5, 12288,     2,     1, 12288,
		    1, 12285,     5,     2, 12286, 12285, 12287,     0,     2, 12288,
		    1, 12288,     1, 12286,     0,     2, 12287, 12287,     6, 12286,
		12288,     0, 12286,     4,     6, 12287, 12287,     2,     2, 12285,
		    1, 12288, 12285, 12286,     5, 12288,     1,     2,     1,     7,
		12286,     5, 12288, 12287, 12286, 12284,     1,     2, 12287,     4,
		    1,     1,     0,     1,     2, 12285,     2, 12288, 12284,     1,
		    1, 12287, 12286, 12285, 12287,     1, 12287,     3,     1, 12286,
		    0, 12286,     3,     3, 12288,     2, 12288,     5, 12288,     1,
		    2,     0, 12287,     1, 12287,     7,     2,     3,     0, 12287,
		    2, 12284, 12284, 12281, 12286, 12285, 12287, 12287,     0, 12288,
		    3,     4,     3,     2,     3,     1, 12288, 12286,     0, 12288,
		12286,     1, 12286,     6, 12287,     1,     6,     5,     3,     1,
		12286,     2,     1,     3,     1, 12286, 12285,     3,     2,     0,
		    0, 12284,     1,     1,     3,     3,     1,     1, 12288,     0,
		12284,     1, 12288,     0,     0, 12287,     0,     4, 12285,     0,
		    4, 12283,     1,     1,     0, 12285,     0, 12286,     0,     0,
		    1,     0, 12286,     0, 12288,     3,     4,     0,     2,     1,
		12287,     2, 12288,     1,     0, 12288,     0, 12288,     6, 12288,
		12287, 12286,     3, 12284,     0, 12288, 12284, 12286, 12287, 12288,
		12288, 12288,     4,     0,     2,     6, 12286,     1,     4, 12288,
		    2,     1,     0,     5,     2,     1, 12285,     0,     0, 12285,
		    4, 12286,     5,     1,     3,     2, 12287,     2,     0,     2,
		    7, 12283, 12288, 12288,     3,     0,     3, 12288,     3, 12286,
		12288, 12287, 12288,     3,     0,     2,     4,     1, 12284,     2,
		12288, 12286, 12287,     1,     1, 12288,     0, 12288, 12283,     6,
		    2,     1, 12288,     3, 12287, 12288,     1,     1, 12285,     0,
		12286, 12287, 12288,     1,     2, 12287,     0,     4,     0, 12286,
		    2,     1, 12288, 12285, 12287,     0,     2, 12287,     6,     2,
		    0, 12287, 12288,     2, 12288, 12284, 12288, 12285,     4,     1,
		12288, 12284, 12287,     4, 12284,     1,     3, 12284, 12282,     0,
		12286, 12287,     2, 12286,     3,     4,     2, 12288,     3,     3,
		    1,     3, 12287, 12283 }
	},
	{ 0x01, 0x01,	/* polynomial e' */
	  { 0x58, 0xd8, 0x6a, 0xcd, 0xe2, 0x79, 0x61, 0x98, 0xfd, 0xea,
		0xcf, 0x2a, 0xc0, 0xfd, 0xf0, 0x72, 0x86, 0x32, 0xdc, 0xe9,
		0xc6, 0x45, 0x81, 0x80, 0x67, 0x06, 0x72, 0x28, 0xa6, 0xfe,
		0x41, 0x2b, 0x78, 0x88, 0x58, 0x6d, 0x58, 0x47, 0x3e, 0xb7,
		0x46, 0x60, 0xd8, 0x2f, 0xa0, 0x83, 0xe4, 0xbc, 0x81, 0xdd,
		0xc6, 0x29, 0x8b, 0xee, 0xf9, 0xec, 0x90, 0x39, 0x9d, 0x46,
		0xbf, 0x2d, 0x7c, 0xdf },
	  { 12287,     3,     3,     1, 12285,     4,     1,     5, 12287, 12285,
		12285, 12285,     1, 12288, 12287, 12288,     2,     3, 12283, 12288,
		12285,     0,     0, 12286, 12287, 12288, 12288, 12288, 12288,     1,
		12288,     2,     2,     5,     5,     0, 12287, 12286,     3,     3,
		    2,     2,     1,     0,     2, 12287, 12285,     3,     1,     3,
		    5,     2, 12287, 12287,     2,     0,     4,     2,     0,     0,
		    1,     5, 12288,     6,     4, 12287,     1,     0, 12283,     0,
		    1, 12286,     2,     0,     2,     1, 12284, 12282,     0,     6,
		    1,     2,     5, 12288,     6, 12288, 12284,     2,     1,     2,
		12288, 12283, 12288,     3, 12288, 12288,     2, 12286, 12283,     1,
		12285,     0,     0, 12286, 12288, 12286, 12288, 12286,     4,     0,
		    1, 12285,     3,     1,     2, 12285, 12287, 12284, 12287, 12285,
		12286,     1, 12288,     3,     5,     5,     3, 12285, 12286, 12288,
		    0,     1, 12287, 12284,     2,     4, 12288, 12287,     0, 12288,
		12288, 12285, 12288, 12284,     3,     0,     2,     0,     2,     0,
		    1,     1,     1, 12287,     1, 12284, 12285,     0, 12284,     1,
		12284,     2, 12288,     5,     4,     1,     1, 12284,     1,     3,
		    2,     6,     3,     2,     3, 12284,     0,     0,     4,     2,
		    6,     2,     2,     2,     6, 12288,     0,     1, 12286,     1,
		    5,     1, 12283,     2,     0, 12284,     1, 12286,     4,     1,
		    2,     4,     6, 12288, 12288, 12284,     1,     0,     3, 12286,
		    1,     0,     3, 12288, 12287,     2,     2,     0, 12285, 12286,
		    0, 12288,     4,     2, 12282, 12287,     1, 12288, 12287, 12286,
		12284,     1,     4,     2,     7, 12288, 12283, 12288,     5, 12288,
		12288, 12287,     3,     2, 12287,     5, 12287, 12286, 12288, 12287,
		    0, 12282, 12288, 12288,     0,     3, 12287,     2, 12287, 12284,
		    6, 12285,     2,     3,     3, 12284,     2,     4, 12286,     5,
		    0,     2, 12287,     3,     0, 12284, 12286,     0,     2, 12286,
		12287,     3,     1,     4,     1, 12286, 12288,     1,     2,     0,
		12285, 12287,     2,     0,     0,     0,     3, 12286, 12287,     2,
		    0,     0,     0, 12286,     4,     1, 12287,     0,     0,     2,
		    5,     0, 12284,     1,     1, 12288,     2, 12286, 12288,     2,
		    2, 12282,     1, 12286,     4, 12286,     3, 12287, 12287, 12286,
		    5,     5,     0, 12288,     3, 12285,     1, 12287,     7, 12286,
		    2, 12287,     1, 12285,     2, 12287, 12288,     0,     4, 12281,
		    0, 12286,     3,     1, 12285,     2,     2, 12285,     5,     0,
		12285,     2, 12288,     1,     3, 12287,     1, 12288,     1,     5,
		12287,     1,     0,     3,     2, 12286, 12286, 12288,     3,     0,
		12287, 12288,     0, 12286, 12285,     0, 12286, 12288,     3, 12287,
		12288,     2,     6,     0,     2, 12285,     1,     1,     7,     7,
		12284, 12284,     5,     0, 12288, 12288,     4,     3,     1,     2,
		12287,     0, 12288, 12284,     2,     5,     1,     2,     0, 12288,
		    1, 12284,     2,     3,     0, 12287, 12285,     2, 12288, 12288,
		    7,     1, 12287,     1, 12286,     2,     3,     4, 12288, 12288,
		12286, 12286,     3, 12288,     1, 12286, 12286,     0, 12283, 12288,
		    2,     0,     7,     2, 12287,     0,     0, 12286,     4,     1,
		12288, 12288,     1,     2, 12287, 12282,     3,     5,     0, 12288,
		12288, 12286, 12286, 12286,     4,     2,     0,     1, 12284,     3,
		12283,     5, 12287,     2,     2, 12288,     1, 12284,     1,     0,
		    1,     3, 12288,     2, 12287,     1, 12286, 12288,     0, 12287,
		12288,     2,     2, 12286,     0, 12287, 12288, 12284,     0,     2,
		    2,     2,     1,     3, 12285, 12285,     1, 12285,     2,     6,
		    2,     0, 12288,     0,     0,     3,     2, 12287,     1, 12286,
		    0, 12287,     0,     1, 12285, 12287,     6, 12288,     2,     0,
		12286,     2,     4, 12288,     2,     5, 12285, 12286,     0, 12284,
		12288,     3,     3,     3, 12287,     4,     2,     0, 12283,     2,
		12287,     0,     1, 12287,     2, 12288, 12287,     3,     2,     7,
		    7,     1, 12287, 12288,     2,     6,     1,     3,     2,     0,
		    2,     2,     3, 12288,     3,     4,     2,     0,     5, 12285,
		    3, 12285,     3, 12285,     1,     1, 12287, 12285,     2, 12285,
		    5,     0,     7,     2, 12284,     0, 12285,     7,     1, 12288,
		12288,     0, 12288, 12287,     5,     0,     2,     0,     2, 12286,
		    1, 12286,     0, 12286, 12285,     4, 12286,     2, 12288, 12287,
		12287,     1, 12286, 12287, 12287, 12286, 12287, 12288,     6,     5,
		    2,     5, 12283, 12286, 12286, 12288,     1,     0,     3, 12286,
		    5,     0, 12287, 12288, 12288, 12287, 12286,     2,     1,     0,
		    1,     2,     3,     1, 12286,     2,     1,     6, 12288,     1,
		12286,     1, 12288,     0,     1,     0, 12283,     0,     2, 12288,
		    3,     1, 12287, 12288,     4,     0,     3, 12286,     0,     1,
		12283,     4,     1,     4, 12287,     5,     0, 12287, 12288,     3,
		    3, 12282,     1,     4,     2,     3,     0,     2,     6, 12282,
		12285, 12288, 12287, 12288,     2, 12285,     1,     0, 12287, 12288,
		12286,     0,     0,     4, 12288, 12287,     1,     0,     2,     5,
		    2, 12287,     1,     7, 12284,     0, 12287, 12286,     2,     1,
		12287,     0,     1, 12284, 12287, 12287, 12285, 12285,     3, 12282,
		12286,     1,     1, 12288, 12282, 12287,     1,     1,     2,     2,
		    3,     1, 12287,     5, 12282,     0,     0, 12287,     1,     3,
		12288,     3, 12285, 12286,     2,     0, 12288, 12288,     5, 12285,
		    4, 12288, 12287,     0,     1,     4,     1,     2, 12288,     0,
		    2,     1, 12288,     4,     6, 12288,     1, 12287,     4,     1,
		12285, 12288,     3,     0, 12288, 12285,     2,     0, 12286,     2,
		    1, 12288,     1, 12288, 12284,     3,     0,     2,     2, 12288,
		12287, 12286,     4, 12288,     2,     0,     0,     3,     4,     0,
		12288, 12282,     6,     2, 12283, 12287,     2,     6,     1,     2,
		12288,     2, 12283,     3, 12287,     3,     4,     0,     0, 12285,
		    0, 12288, 12287, 12284, 12286,     3,     1, 12286,     2,     0,
		12287, 12286, 12286, 12288,     5,     2, 12288, 12286,     0, 12287,
		    0,     3,     2, 12287, 12286,     0,     1, 12287,     2,     0,
		12286,     5, 12285, 12288, 12288, 12288, 12286,     4,     1, 12285,
		12284, 12288, 12286,     1,     1, 12287,     2, 12286,     3,     2,
		12283, 12283,     4,     2, 12283,     5,     0,     1,     0,     5,
		12287,     1,     1,     0,     3,    10, 12287,     3, 12288, 12288,
		12287,     2,     2,     0,     4, 12288, 12283, 12288,     1, 12287,
		    3,     0,     0,     1, 12288, 12284,     0, 12286, 12287,     0,
		12287,     2,     1,     7, 12288, 12287,     0,     4, 12287, 12286,
		    3,     4, 12287, 12288, 12285, 12287, 12288, 12285, 12286,     7,
		    1,     1, 12288,     3, 12287,     3,     1,     4,     2,     5,
		12282,     3,     0, 12286, 12288,     0, 12285,     0,     2,     3,
		    0, 12286,     3,     2, 12285,     0,     0, 12287,     1,     0,
		    0,     6,     2, 12287, 12284,     7,     5,     0,     1,     6,
		    2,     4,     1, 12286, 12288,     2, 12287,     3,     4, 12283,
		    0, 12288,     2,     2, 12286,     0,     2,     2, 12288, 12285,
		12287, 12285, 12288,     0 }
	},
	{ 0x01, 0x02,	/* polynomial e'' */
	  { 0x20, 0x37, 0x77, 0x8a, 0x9c, 0x19, 0xde, 0xf0, 0x65, 0x9e,
		0x0f, 0xa5, 0xfc, 0x0e, 0x78, 0xfe, 0x55, 0x89, 0xc9, 0x88,
		0x41, 0xa2, 0x5a, 0x1e, 0xa4, 0x66, 0xcd, 0x3a, 0x29, 0x42,
		0xd1, 0x25, 0xf2, 0x84, 0xd7, 0xee, 0xd5, 0x53, 0x86, 0x5b,
		0xa3, 0x93, 0x4e, 0xee, 0xc7, 0x5b, 0xe5, 0x52, 0x68, 0x19,
		0xdf, 0x63, 0xfb, 0x91, 0x3d, 0xe9, 0x5d, 0xd6, 0xeb, 0x81,
		0x3d, 0xac, 0xf1, 0xad },
	  { 12286, 12286,     1, 12287,     1, 12286, 12287, 12287, 12284,     1,
		12287,     2, 12284,     0,     2, 12288,     0,     1,     0, 12285,
		12288,     4,     2, 12287, 12282, 12288, 12285, 12288,     2, 12288,
		    6,     7, 12286, 12286,     1,     4, 12287, 12287,     3,     1,
		    3,     3,     2, 12285,     0,     1, 12288,     1,     1, 12287,
		    0,     0,     1,     0, 12287, 12283, 12283, 12288, 12287,     0,
		    0,     2, 12286,     3,     3,     0, 12286, 12282,     3,     6,
		    3,     3, 12285,     1,     1, 12288,     1,     0, 12288,     0,
		12287,     4,     1,     0, 12285, 12288,     1,     1,     1,     3,
		12286,     0, 12288,     0, 12287, 12287,     3,     5,     1, 12287,
		12287,     0,     0,     0, 12283,     0,     0, 12288,     0, 12287,
		12286, 12284, 12286,     0, 12286,     3,     5, 12287,     0, 12287,
		    1,     3,     2,     6,     1, 12287,     1,     1, 12285,     4,
		12282, 12288, 12288,     3,     2, 12287,     3,     3, 12288, 12286,
		    2,     5, 12288, 12287, 12288,     3,     0, 12283,     3,     3,
		    1,     0, 12288,     2,     2, 12287, 12286,     4, 12287, 12288,
		    0,     0, 12286,     1,     4,     4, 12286, 12287,     4, 12288,
		    2,     1,     1, 12288, 12287,     3, 12287, 12286, 12285, 12288,
		    4,     1,     0, 12287,     3, 12286, 12287,     4,     0, 12287,
		12286, 12287,     3,     1,     1, 12285, 12287,     0, 12285,     2,
		    5,     2, 12285,     3,     2, 12285, 12287,     2,     0, 12288,
		    2,     5,     2, 12283,     1,     1,     0, 12286, 12288,     3,
		    1, 12286, 12283,     0,     1,     2,     2,     1, 12287, 12287,
		    4,     4,     1,     0,     0, 12288, 12287, 12284, 12284,     7,
		    0, 12288,     5,     4, 12288, 12288,     1,     0,     1,     1,
		    2, 12288, 12288,     5,     1,     0, 12287,     3,     3,     0,
		    1, 12288, 12288,     3, 12285, 12288,     3,     5,     4,     1,
		12285, 12285, 12288, 12285, 12288, 12285,     4,     1,     3, 12285,
		    4,     0, 12288, 12286,     5, 12287, 12285, 12288,     4, 12288,
		    0, 12287, 12286,     0, 12286, 12283,     0, 12287, 12284,     1,
		12288, 12288,     3, 12286,     1,     2, 12286,     3,     1, 12285,
		12286, 12285,     0, 12285, 12288,     0,     2, 12283,     0,     1,
		    2,     1,     2,     3,     3, 12285,     0,     0,     0, 12288,
		12283,     4, 12286,     2,     1,     3,     3, 12284,     2,     4,
		    3, 12286, 12282, 12286,     0, 12286, 12287,     3, 12288, 12288,
		    2, 12287, 12286,     3,     0, 12286,     1,     1,     0, 12287,
		    2,     0,     0,     1, 12286,     1,     0, 12283,     0, 12288,
		    2,     5, 12288, 12287,     2,     1, 12288,     2,     2,     5,
		    2, 12286, 12286,     2, 12284, 12287,     0, 12284,     0, 12284,
		12286, 12286, 12288, 12287, 12287,     2,     1, 12287, 12287,     1,
		    5,     0,     0, 12288,     2, 12285,     6,     2, 12288, 12288,
		12286,     2, 12285,     0,     0,     0, 12288,     3, 12286,     1,
		    1,     0,     3,     0, 12286, 12288, 12287,     3,     2, 12287,
		12288,     1, 12288, 12282,     2,     0, 12288, 12286, 12285, 12281,
		    4,     1,     7, 12283, 12287, 12288,     1,     6,     0, 12288,
		    5,     1,     1, 12286, 12286,     0, 12287, 12285, 12287,     1,
		12288, 12286, 12286, 12288,     2, 12287, 12287, 12288, 12286, 12288,
		12282, 12284, 12286,     0, 12285, 12285,     3, 12288, 12287, 12288,
		    2,     0,     2,     0, 12288, 12286,     3, 12288, 12286, 12287,
		    1,     1,     1,     0,     5,     5, 12285, 12288,     3, 12286,
		    1,     2, 12285,     1,     4, 12288,     1,     4,     1,     3,
		    4, 12286,     0,     7,     2, 12288,     2, 12287,     0,     2,
		12283, 12286,     0, 12288, 12286,     4,     1, 12284,     7, 12285,
		    0, 12284, 12287,     0,     0,     3,     4, 12284,     0,     1,
		    0,     1, 12285,     1, 12286, 12284, 12287,     0,     7,     1,
		    4, 12282, 12288,     0,     2, 12285, 12288, 12287, 12287, 12283,
		    0,     1,     3, 12285, 12286,     3, 12288, 12288, 12284, 12286,
		12288,     1,     0,     2, 12287,     0, 12286,     4, 12288,     0,
		12284,     0,     0,     2, 12286,     0,     0, 12286, 12287,     1,
		12288,     0, 12284,     1, 12288, 12288,     1,     1, 12282, 12284,
		12288, 12285, 12285, 12288,     1, 12286,     2,     0,     0, 12284,
		    2, 12288,     0,     0, 12285,     0,     3,     0,     0, 12285,
		12286,     5,     3, 12287,     5,     2, 12287,     0,     1, 12286,
		12287,     1, 12286,     1, 12288,     0,     0, 12282,     5, 12282,
		12287, 12288, 12287,     1,     0,     3,     4,     6,     1,     1,
		12287, 12284, 12286, 12287, 12286,     2,     1, 12288,     3,     0,
		    3,     0, 12286,     1,     0, 12288,     1, 12284,     4,     0,
		    4, 12288,     1,     4,     1, 12286,     4,     0,     2,     1,
		    1,     4, 12287,     2,     1, 12288,     4,     3,     2, 12287,
		    0,     1, 12287,     1, 12285, 12286,     2,     2,     0, 12286,
		12287,     0, 12288, 12285,     5, 12288,     0,     0, 12288,     3,
		12288,     0,     4,     0, 12288, 12286, 12287,     0,     0,     2,
		12283,     0, 12281,     1,     1,     3,     4,     2, 12284,     5,
		12288,     2,     3,     4, 12287,     3, 12288, 12287, 12288,     2,
		12286,     2,     0, 12286, 12286,     5, 12288,     2, 12288,     7,
		12286, 12286,     4, 12288, 12288, 12288,     5, 12287,     7, 12286,
		12282,     2, 12284,     0, 12288,     0,     2, 12283,     2,     5,
		    4,     1, 12288, 12283,     5, 12288, 12288,     0,     0,     0,
		    6,     1, 12286,     6,     4, 12287,     2, 12288, 12287, 12286,
		    4,     5,     0,     1,     2,     1,     4, 12286,     1,     2,
		    1,     1,     0, 12288, 12282,     1,     1,     3, 12284, 12288,
		    0, 12287,     1, 12286, 12288,     6,     1,     5, 12287, 12285,
		    2, 12288, 12288, 12284,     0, 12287,     2,     3,     5,     1,
		12286,     1, 12287,     0, 12284,     1,     5, 12283,     1,     1,
		12287, 12283, 12288,     0, 12287,     3,     0, 12288, 12286, 12287,
		    8,     0,     0, 12288,     1,     3,     2,     3, 12287,     9,
		    2,     3,     4, 12288,     3,     0, 12288, 12283,     0,     0,
		    2,     4, 12287,     2, 12287, 12286, 12287,     2, 12287,     2,
		    3,     1,     3,     1,     0,     1,     1,     5,     3, 12285,
		    1, 12281, 12287, 12286,     1,     4, 12287, 12286, 12285,     4,
		    2,     0, 12288, 12288, 12286, 12287, 12288,     1,     3,     4,
		    0,     1, 12285,     4,     3, 12284,     1, 12288, 12285, 12288,
		    0, 12281, 12288, 12285, 12285,     1, 12284, 12286, 12287,     0,
		    0, 12287,     1, 12282,     4,     4, 12288,     1,     4, 12286,
		    5,     4,     1,     5,     3,     1,     0,     6, 12288,     0,
		12288,     2, 12286, 12287,     6,     0, 12288,     0, 12287,     1,
		    4,     0, 12282,     4,     1, 12286,     1, 12282,     3, 12285,
		12283, 12286, 12288,     4, 12284, 12286, 12286,     0, 12286,     0,
		    0,     1, 12286,     1,     1,     4, 12284,     0,     3,     2,
		12288,     1,     2, 12287,     2,     1, 12288,     0,     1,     2,
		12286,     0,     6, 12285,     0,     1,     4,     0,     0,     3,
		    2, 12287, 12285,     7,     1,     3,     1,     0, 12286, 12288,
		    0, 12287,     1, 12286 }
	}
};

START_TEST(test_newhope_noise_uniform)
{
	newhope_noise_t *noise;
	uint8_t seed_buf[seed_len], *uniform;
	chunk_t seed = { seed_buf, seed_len };

	memset(seed_buf, 0x00, seed_len - 1);
	seed_buf[seed_len - 1] = noises[_i].key;

	noise = newhope_noise_create(seed);
	ck_assert(noise != NULL);
	uniform = noise->get_uniform_bytes(noise, noises[_i].nonce, 64);
	ck_assert(uniform != NULL);
	ck_assert(memeq(uniform, noises[_i].uniform, 64));
	free(uniform);
	noise->destroy(noise);
}
END_TEST

START_TEST(test_newhope_noise_poly)
{
	newhope_noise_t *noise;
	uint8_t seed_buf[seed_len];
	uint32_t *poly;
	int i;
	chunk_t seed = { seed_buf, seed_len };

	memset(seed_buf, 0x00, seed_len - 1);
	seed_buf[seed_len - 1] = noises[_i].key;

	noise = newhope_noise_create(seed);
	ck_assert(noise != NULL);
	poly = noise->get_binomial_words(noise, noises[_i].nonce, n, q);
	ck_assert(poly != NULL);
	for (i = 0; i < n; i++)
	{
		ck_assert(poly[i] == noises[_i].poly[i]);
	}
	free(poly);
	noise->destroy(noise);
}
END_TEST

static size_t seed_lengths[] = { 0, 1, 31, 33 };

START_TEST(test_newhope_noise_fail)
{
	newhope_noise_t *noise;
	chunk_t seed;

	seed = chunk_alloc(seed_lengths[_i]);
	memset(seed.ptr, 0x00, seed.len);

	noise = newhope_noise_create(seed);
	ck_assert(noise == NULL);
	chunk_free(&seed);
}
END_TEST

Suite *newhope_noise_suite_create()
{
	Suite *s;
	TCase *tc;

	s = suite_create("newhope_noise");

	tc = tcase_create("noise_uniform");
	tcase_add_loop_test(tc, test_newhope_noise_uniform, 0, countof(noises));
	suite_add_tcase(s, tc);

	tc = tcase_create("noise_poly");
	tcase_add_loop_test(tc, test_newhope_noise_poly, 0, countof(noises));
	suite_add_tcase(s, tc);

	tc = tcase_create("noise_fail");
	tcase_add_loop_test(tc, test_newhope_noise_fail, 0, countof(seed_lengths));
	suite_add_tcase(s, tc);

	return s;
}
