/*********************************************************************************/
/* freeDiameter author note:
 *  The content from this file comes directly from the hostap project.
 * It is redistributed under the terms of the BSD license, as allowed
 * by the original copyright reproduced below.
 */

/*********************************************************************************/

/*
 * MD5 hash implementation and interface functions
 * Copyright (c) 2003-2005, Jouni Malinen <j@w1.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Alternatively, this software may be distributed under the terms of BSD
 * license.
 *
 * See README and COPYING for more details.
 */

#ifndef MD5_H
#define MD5_H

#define MD5_MAC_LEN 16

void hmac_md5_vector(const u8 *key, size_t key_len, size_t num_elem,
		     const u8 *addr[], const size_t *len, u8 *mac);
void hmac_md5(const u8 *key, size_t key_len, const u8 *data, size_t data_len,
	      u8 *mac);

#ifdef CONFIG_CRYPTO_INTERNAL
struct MD5Context;

void MD5Init(struct MD5Context *context);
void MD5Update(struct MD5Context *context, unsigned char const *buf,
	       unsigned len);
void MD5Final(unsigned char digest[16], struct MD5Context *context);
#endif /* CONFIG_CRYPTO_INTERNAL */

 /* Forward declaration: */
void md5_vector(size_t num_elem, const u8 *addr[], const size_t *len, u8 *mac);

#endif /* MD5_H */
