-module(pkt_icmp6_tests).

-include_lib("pkt/include/pkt.hrl").
-include_lib("eunit/include/eunit.hrl").

codec_test_() ->
    [
        decode(),
        encode(),
        decode_rfc4861(),
        encode_rfc4861()
    ].

packet() ->
    <<128,0,255,149,7,79,0,1,169,244,102,82,0,0,0,0,36,187,0,
      0,0,0,0,0,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,
      31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,
      49,50,51,52,53,54,55>>.

decode() ->
    {Header, Payload} = pkt:icmp6(packet()),
    ?_assertEqual(
        {#icmp6{type = 128,code = 0,checksum = 65429,
                un = <<0,0,0,0>>,
                pptr = 0,mtu = 0,id = 1871,seq = 1,maxdelay = 0,res = 0,
                res2 = 0,saddr = {0,0,0,0,0,0,0,0},daddr = {0,0,0,0,0,0,0,0},hop = 0,m = 0,
                o = 0,lifetime = 0,reach = 0,retrans = 0,r = 0,s = 0,
                delay = 0},
          <<169,244,102,82,0,0,0,0,36,187,0,0,0,0,0,0,16,17,18,19,
            20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,
            38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55>>},
        {Header, Payload}
    ).

encode() ->
    Packet = packet(),
    {Header, Payload} = pkt:icmp6(Packet),
    ?_assertEqual(Packet, <<(pkt:icmp6(Header))/binary, Payload/binary>>).

packet_rfc4861() ->
	<<133,0,171,189,0,0,0,0,1,1,82,84,0,117,74,88,11,41,5,0,
	  125,99,38,190,84,120,235,111,241,94,13,46,203,174,76,
	  165,254,128,131,0,32,1,255,255,0,48,130,1,34,48,13,6,9,
	  42,134,72,134,247,13,1,1,1,5,0,3,130,1,15,0,48,130,1,10,
	  2,130,1,1,0,205,129,138,159,96,224,29,12,187,120,227,66,
	  203,242,10,168,128,62,16,235,94,251,49,192,23,249,129,
	  177,245,83,75,179,130,109,10,191,128,166,97,100,53,154,
	  66,90,19,208,177,212,38,114,40,208,16,206,239,160,190,
	  210,245,35,250,228,26,241,243,60,232,177,130,36,195,254,
	  217,228,63,104,101,48,92,132,156,175,209,125,248,74,182,
	  61,123,220,15,92,218,32,122,40,59,145,42,129,139,152,
	  204,128,205,237,217,53,4,79,192,174,146,203,54,30,221,
	  167,14,82,114,136,181,164,61,3,45,181,76,83,35,46,113,
	  124,97,244,126,45,151,41,0,196,227,140,5,88,129,137,93,
	  244,224,100,15,214,164,12,229,41,191,103,183,145,22,69,
	  34,142,74,173,91,77,182,51,13,182,248,121,152,3,154,187,
	  168,65,21,232,233,130,32,146,84,68,211,159,203,91,73,21,
	  206,79,172,92,237,113,168,100,99,34,196,30,233,73,144,
	  80,226,111,221,178,178,231,100,115,35,53,226,221,205,
	  151,3,195,184,124,172,172,93,49,69,109,91,20,207,207,
	  192,202,170,218,237,222,7,37,176,192,22,251,114,70,33,
	  123,2,3,1,0,1,0,0,0,0,0,13,2,0,0,0,0,0,0,0,0,89,121,136,
	  185,0,0,14,1,62,244,73,12,171,237,12,35,0,0,112,190,22,
	  112,142,166,156,168,104,254,69,199,58,217,219,241,174,
	  101,234,231,179,49,253,242,212,46,245,105,167,41,234,
	  191,56,219,97,163,26,170,146,56,237,138,99,67,155,219,
	  253,59,73,161,63,251,149,207,44,129,23,171,121,204,90,
	  242,32,27,114,50,56,5,81,177,78,174,65,197,193,181,122,
	  50,140,27,50,216,166,4,81,124,69,19,19,200,91,237,115,
	  193,90,133,23,135,237,237,192,106,233,221,134,26,164,
	  170,236,133,221,90,38,12,195,226,238,21,114,162,6,194,
	  106,177,193,61,1,205,115,19,242,179,217,117,153,174,79,
	  49,153,6,9,186,199,75,196,63,251,31,56,57,21,145,119,
	  228,239,20,114,119,131,112,156,220,251,19,120,146,134,
	  223,141,145,21,193,222,5,253,180,247,61,80,56,171,81,84,
	  248,140,151,230,186,11,83,62,159,211,167,56,209,44,115,
	  33,134,201,203,64,93,67,127,94,94,33,136,223,204,102,
	  120,98,245,48,196,91,103,154,59,29,79,240,186,233,148,
	  64,35,210,252,1,251,198,42,58,254,77,161,223,184,247,
	  115,116,28,1,248,147,151,43,24,121,64,45,104,250,239,
	  107,236,222,224,53,179,107,69,69,99,169,169,65,154,0,0,
	  0,0>>.

decode_rfc4861() ->
    {Header, Payload} = pkt:icmp6(packet_rfc4861()),
    ?_assertEqual(
	{{icmp6,133,0,43965,
			<<0,0,0,0>>,
			0,0,0,0,0,0,0,
			{0,0,0,0,0,0,0,0},
			{0,0,0,0,0,0,0,0},
			0,0,0,0,0,0,0,0,0},
	 <<1,1,82,84,0,117,74,88,11,41,5,0,125,99,38,190,84,120,
	   235,111,241,94,13,46,203,174,76,165,254,128,131,0,32,1,
	   255,255,0,48,130,1,34,48,13,6,9,42,134,72,134,247,13,1,
	   1,1,5,0,3,130,1,15,0,48,130,1,10,2,130,1,1,0,205,129,
	   138,159,96,224,29,12,187,120,227,66,203,242,10,168,128,
	   62,16,235,94,251,49,192,23,249,129,177,245,83,75,179,
	   130,109,10,191,128,166,97,100,53,154,66,90,19,208,177,
	   212,38,114,40,208,16,206,239,160,190,210,245,35,250,
	   228,26,241,243,60,232,177,130,36,195,254,217,228,63,
	   104,101,48,92,132,156,175,209,125,248,74,182,61,123,
	   220,15,92,218,32,122,40,59,145,42,129,139,152,204,128,
	   205,237,217,53,4,79,192,174,146,203,54,30,221,167,14,
	   82,114,136,181,164,61,3,45,181,76,83,35,46,113,124,97,
	   244,126,45,151,41,0,196,227,140,5,88,129,137,93,244,
	   224,100,15,214,164,12,229,41,191,103,183,145,22,69,34,
	   142,74,173,91,77,182,51,13,182,248,121,152,3,154,187,
	   168,65,21,232,233,130,32,146,84,68,211,159,203,91,73,
	   21,206,79,172,92,237,113,168,100,99,34,196,30,233,73,
	   144,80,226,111,221,178,178,231,100,115,35,53,226,221,
	   205,151,3,195,184,124,172,172,93,49,69,109,91,20,207,
	   207,192,202,170,218,237,222,7,37,176,192,22,251,114,70,
	   33,123,2,3,1,0,1,0,0,0,0,0,13,2,0,0,0,0,0,0,0,0,89,121,
	   136,185,0,0,14,1,62,244,73,12,171,237,12,35,0,0,112,
	   190,22,112,142,166,156,168,104,254,69,199,58,217,219,
	   241,174,101,234,231,179,49,253,242,212,46,245,105,167,
	   41,234,191,56,219,97,163,26,170,146,56,237,138,99,67,
	   155,219,253,59,73,161,63,251,149,207,44,129,23,171,121,
	   204,90,242,32,27,114,50,56,5,81,177,78,174,65,197,193,
	   181,122,50,140,27,50,216,166,4,81,124,69,19,19,200,91,
	   237,115,193,90,133,23,135,237,237,192,106,233,221,134,
	   26,164,170,236,133,221,90,38,12,195,226,238,21,114,162,
	   6,194,106,177,193,61,1,205,115,19,242,179,217,117,153,
	   174,79,49,153,6,9,186,199,75,196,63,251,31,56,57,21,
	   145,119,228,239,20,114,119,131,112,156,220,251,19,120,
	   146,134,223,141,145,21,193,222,5,253,180,247,61,80,56,
	   171,81,84,248,140,151,230,186,11,83,62,159,211,167,56,
	   209,44,115,33,134,201,203,64,93,67,127,94,94,33,136,
	   223,204,102,120,98,245,48,196,91,103,154,59,29,79,240,
	   186,233,148,64,35,210,252,1,251,198,42,58,254,77,161,
	   223,184,247,115,116,28,1,248,147,151,43,24,121,64,45,
	   104,250,239,107,236,222,224,53,179,107,69,69,99,169,
	   169,65,154,0,0,0,0>>},
       {Header, Payload}
    ).

encode_rfc4861() ->
    Packet = packet(),
    {Header, Payload} = pkt:icmp6(Packet),
    ?_assertEqual(Packet, <<(pkt:icmp6(Header))/binary, Payload/binary>>).
