/*
 * Copyright (C) 2019-2023 by Sukchan Lee <acetcom@gmail.com>
 *
 * This file is part of Open5GS.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef OGS_NGAP_H
#define OGS_NGAP_H

#include "core/ogs-core.h"

#include "NGAP_ActivatedCellList.h"
#include "NGAP_AdditionalDLUPTNLInformationForHOItem.h"
#include "NGAP_AdditionalDLUPTNLInformationForHOList.h"
#include "NGAP_AdditionalQosFlowInformation.h"
#include "NGAP_AllocationAndRetentionPriority.h"
#include "NGAP_Allowed-CAG-List-per-PLMN.h"
#include "NGAP_AllowedNSSAI.h"
#include "NGAP_AllowedNSSAI-Item.h"
#include "NGAP_Allowed-PNI-NPN-Item.h"
#include "NGAP_Allowed-PNI-NPN-List.h"
#include "NGAP_AllowedTACs.h"
#include "NGAP_AlternativeQoSParaSetIndex.h"
#include "NGAP_AlternativeQoSParaSetItem.h"
#include "NGAP_AlternativeQoSParaSetList.h"
#include "NGAP_AlternativeQoSParaSetNotifyIndex.h"
#include "NGAP_AMFConfigurationUpdateAcknowledge.h"
#include "NGAP_AMFConfigurationUpdateFailure.h"
#include "NGAP_AMFConfigurationUpdate.h"
#include "NGAP_AMFCPRelocationIndication.h"
#include "NGAP_AMFName.h"
#include "NGAP_AMFNameUTF8String.h"
#include "NGAP_AMFNameVisibleString.h"
#include "NGAP_AMFPagingTarget.h"
#include "NGAP_AMFPointer.h"
#include "NGAP_AMFRegionID.h"
#include "NGAP_AMFSetID.h"
#include "NGAP_AMFStatusIndication.h"
#include "NGAP_AMF-TNLAssociationSetupItem.h"
#include "NGAP_AMF-TNLAssociationSetupList.h"
#include "NGAP_AMF-TNLAssociationToAddItem.h"
#include "NGAP_AMF-TNLAssociationToAddList.h"
#include "NGAP_AMF-TNLAssociationToRemoveItem.h"
#include "NGAP_AMF-TNLAssociationToRemoveList.h"
#include "NGAP_AMF-TNLAssociationToUpdateItem.h"
#include "NGAP_AMF-TNLAssociationToUpdateList.h"
#include "NGAP_AMF-UE-NGAP-ID.h"
#include "NGAP_AreaOfInterestCellItem.h"
#include "NGAP_AreaOfInterestCellList.h"
#include "NGAP_AreaOfInterest.h"
#include "NGAP_AreaOfInterestItem.h"
#include "NGAP_AreaOfInterestList.h"
#include "NGAP_AreaOfInterestRANNodeItem.h"
#include "NGAP_AreaOfInterestRANNodeList.h"
#include "NGAP_AreaOfInterestTAIItem.h"
#include "NGAP_AreaOfInterestTAIList.h"
#include "NGAP_AreaScopeOfMDT-EUTRA.h"
#include "NGAP_AreaScopeOfMDT-NR.h"
#include "NGAP_AreaScopeOfNeighCellsItem.h"
#include "NGAP_AreaScopeOfNeighCellsList.h"
#include "NGAP_AreaScopeOfQMC.h"
#include "NGAP_asn_constant.h"
#include "NGAP_AssistanceDataForPaging.h"
#include "NGAP_AssistanceDataForRecommendedCells.h"
#include "NGAP_AssociatedMBSQosFlowSetuporModifyRequestItem.h"
#include "NGAP_AssociatedMBSQosFlowSetuporModifyRequestList.h"
#include "NGAP_AssociatedMBSQosFlowSetupRequestItem.h"
#include "NGAP_AssociatedMBSQosFlowSetupRequestList.h"
#include "NGAP_AssociatedQosFlowItem.h"
#include "NGAP_AssociatedQosFlowList.h"
#include "NGAP_AuthenticatedIndication.h"
#include "NGAP_AvailableRANVisibleQoEMetrics.h"
#include "NGAP_AveragingWindow.h"
#include "NGAP_BeamMeasurementsReportConfiguration.h"
#include "NGAP_BeamMeasurementsReportQuantity.h"
#include "NGAP_BitRate.h"
#include "NGAP_BluetoothMeasConfig.h"
#include "NGAP_BluetoothMeasConfigNameItem.h"
#include "NGAP_BluetoothMeasConfigNameList.h"
#include "NGAP_BluetoothMeasurementConfiguration.h"
#include "NGAP_BluetoothName.h"
#include "NGAP_BroadcastCancelledAreaList.h"
#include "NGAP_BroadcastCompletedAreaList.h"
#include "NGAP_BroadcastPLMNItem.h"
#include "NGAP_BroadcastPLMNList.h"
#include "NGAP_BroadcastSessionModificationFailure.h"
#include "NGAP_BroadcastSessionModificationRequest.h"
#include "NGAP_BroadcastSessionModificationResponse.h"
#include "NGAP_BroadcastSessionReleaseRequest.h"
#include "NGAP_BroadcastSessionReleaseRequired.h"
#include "NGAP_BroadcastSessionReleaseResponse.h"
#include "NGAP_BroadcastSessionSetupFailure.h"
#include "NGAP_BroadcastSessionSetupRequest.h"
#include "NGAP_BroadcastSessionSetupResponse.h"
#include "NGAP_BurstArrivalTime.h"
#include "NGAP_CAG-ID.h"
#include "NGAP_CancelAllWarningMessages.h"
#include "NGAP_CancelledCellsInEAI-EUTRA.h"
#include "NGAP_CancelledCellsInEAI-EUTRA-Item.h"
#include "NGAP_CancelledCellsInEAI-NR.h"
#include "NGAP_CancelledCellsInEAI-NR-Item.h"
#include "NGAP_CancelledCellsInTAI-EUTRA.h"
#include "NGAP_CancelledCellsInTAI-EUTRA-Item.h"
#include "NGAP_CancelledCellsInTAI-NR.h"
#include "NGAP_CancelledCellsInTAI-NR-Item.h"
#include "NGAP_CandidateCell.h"
#include "NGAP_CandidateCellID.h"
#include "NGAP_CandidateCellItem.h"
#include "NGAP_CandidateCellList.h"
#include "NGAP_CandidatePCI.h"
#include "NGAP_Cause.h"
#include "NGAP_CauseMisc.h"
#include "NGAP_CauseNas.h"
#include "NGAP_CauseProtocol.h"
#include "NGAP_CauseRadioNetwork.h"
#include "NGAP_CauseTransport.h"
#include "NGAP_CellBasedMDT-EUTRA.h"
#include "NGAP_CellBasedMDT-NR.h"
#include "NGAP_CellBasedQMC.h"
#include "NGAP_Cell-CAGInformation.h"
#include "NGAP_CellCAGList.h"
#include "NGAP_CellIDBroadcastEUTRA.h"
#include "NGAP_CellIDBroadcastEUTRA-Item.h"
#include "NGAP_CellIDBroadcastNR.h"
#include "NGAP_CellIDBroadcastNR-Item.h"
#include "NGAP_CellIDCancelledEUTRA.h"
#include "NGAP_CellIDCancelledEUTRA-Item.h"
#include "NGAP_CellIDCancelledNR.h"
#include "NGAP_CellIDCancelledNR-Item.h"
#include "NGAP_CellIdListforMDT-EUTRA.h"
#include "NGAP_CellIdListforMDT-NR.h"
#include "NGAP_CellIdListforQMC.h"
#include "NGAP_CellIDListForRestart.h"
#include "NGAP_CellSize.h"
#include "NGAP_CellsToActivateList.h"
#include "NGAP_CellTrafficTrace.h"
#include "NGAP_CellType.h"
#include "NGAP_CEmodeBrestricted.h"
#include "NGAP_CEmodeBSupport-Indicator.h"
#include "NGAP_CNAssistedRANTuning.h"
#include "NGAP_CNsubgroupID.h"
#include "NGAP_CNTypeRestrictionsForEquivalent.h"
#include "NGAP_CNTypeRestrictionsForEquivalentItem.h"
#include "NGAP_CNTypeRestrictionsForServing.h"
#include "NGAP_CommonNetworkInstance.h"
#include "NGAP_CompletedCellsInEAI-EUTRA.h"
#include "NGAP_CompletedCellsInEAI-EUTRA-Item.h"
#include "NGAP_CompletedCellsInEAI-NR.h"
#include "NGAP_CompletedCellsInEAI-NR-Item.h"
#include "NGAP_CompletedCellsInTAI-EUTRA.h"
#include "NGAP_CompletedCellsInTAI-EUTRA-Item.h"
#include "NGAP_CompletedCellsInTAI-NR.h"
#include "NGAP_CompletedCellsInTAI-NR-Item.h"
#include "NGAP_CompositeAvailableCapacity.h"
#include "NGAP_ConcurrentWarningMessageInd.h"
#include "NGAP_ConfidentialityProtectionIndication.h"
#include "NGAP_ConfidentialityProtectionResult.h"
#include "NGAP_ConfiguredNSSAI.h"
#include "NGAP_ConfiguredTACIndication.h"
#include "NGAP_ConnectionEstablishmentIndication.h"
#include "NGAP_CoreNetworkAssistanceInformationForInactive.h"
#include "NGAP_COUNTValueForPDCP-SN12.h"
#include "NGAP_COUNTValueForPDCP-SN18.h"
#include "NGAP_CoverageEnhancementLevel.h"
#include "NGAP_CPTransportLayerInformation.h"
#include "NGAP_CriticalityDiagnostics.h"
#include "NGAP_CriticalityDiagnostics-IE-Item.h"
#include "NGAP_CriticalityDiagnostics-IE-List.h"
#include "NGAP_Criticality.h"
#include "NGAP_DAPSRequestInfo.h"
#include "NGAP_DAPSResponseInfo.h"
#include "NGAP_DAPSResponseInfoItem.h"
#include "NGAP_DAPSResponseInfoList.h"
#include "NGAP_DataCodingScheme.h"
#include "NGAP_DataForwardingAccepted.h"
#include "NGAP_DataForwardingNotPossible.h"
#include "NGAP_DataForwardingResponseDRBItem.h"
#include "NGAP_DataForwardingResponseDRBList.h"
#include "NGAP_DataForwardingResponseERABList.h"
#include "NGAP_DataForwardingResponseERABListItem.h"
#include "NGAP_DeactivateTrace.h"
#include "NGAP_DelayCritical.h"
#include "NGAP_DirectForwardingPathAvailability.h"
#include "NGAP_DistributionReleaseRequest.h"
#include "NGAP_DistributionReleaseResponse.h"
#include "NGAP_DistributionSetupFailure.h"
#include "NGAP_DistributionSetupRequest.h"
#include "NGAP_DistributionSetupResponse.h"
#include "NGAP_DL-CP-SecurityInformation.h"
#include "NGAP_DLForwarding.h"
#include "NGAP_DL-NAS-MAC.h"
#include "NGAP_DL-NGU-TNLInformationReused.h"
#include "NGAP_DownlinkNASTransport.h"
#include "NGAP_DownlinkNonUEAssociatedNRPPaTransport.h"
#include "NGAP_DownlinkRANConfigurationTransfer.h"
#include "NGAP_DownlinkRANEarlyStatusTransfer.h"
#include "NGAP_DownlinkRANStatusTransfer.h"
#include "NGAP_DownlinkRIMInformationTransfer.h"
#include "NGAP_DownlinkUEAssociatedNRPPaTransport.h"
#include "NGAP_DRB-ID.h"
#include "NGAP_DRBsSubjectToEarlyStatusTransfer-Item.h"
#include "NGAP_DRBsSubjectToEarlyStatusTransfer-List.h"
#include "NGAP_DRBsSubjectToStatusTransferItem.h"
#include "NGAP_DRBsSubjectToStatusTransferList.h"
#include "NGAP_DRBStatusDL12.h"
#include "NGAP_DRBStatusDL18.h"
#include "NGAP_DRBStatusDL.h"
#include "NGAP_DRBStatusUL12.h"
#include "NGAP_DRBStatusUL18.h"
#include "NGAP_DRBStatusUL.h"
#include "NGAP_DRBsToQosFlowsMappingItem.h"
#include "NGAP_DRBsToQosFlowsMappingList.h"
#include "NGAP_Dynamic5QIDescriptor.h"
#include "NGAP_EarlyMeasurement.h"
#include "NGAP_EarlyStatusTransfer-TransparentContainer.h"
#include "NGAP_EDT-Session.h"
#include "NGAP_EmergencyAreaIDBroadcastEUTRA.h"
#include "NGAP_EmergencyAreaIDBroadcastEUTRA-Item.h"
#include "NGAP_EmergencyAreaIDBroadcastNR.h"
#include "NGAP_EmergencyAreaIDBroadcastNR-Item.h"
#include "NGAP_EmergencyAreaIDCancelledEUTRA.h"
#include "NGAP_EmergencyAreaIDCancelledEUTRA-Item.h"
#include "NGAP_EmergencyAreaIDCancelledNR.h"
#include "NGAP_EmergencyAreaIDCancelledNR-Item.h"
#include "NGAP_EmergencyAreaID.h"
#include "NGAP_EmergencyAreaIDListForRestart.h"
#include "NGAP_EmergencyAreaIDList.h"
#include "NGAP_EmergencyFallbackIndicator.h"
#include "NGAP_EmergencyFallbackRequestIndicator.h"
#include "NGAP_EmergencyServiceTargetCN.h"
#include "NGAP_ENB-ID.h"
#include "NGAP_EN-DCSONConfigurationTransfer.h"
#include "NGAP_EndIndication.h"
#include "NGAP_EndpointIPAddressAndPort.h"
#include "NGAP_Enhanced-CoverageRestriction.h"
#include "NGAP_EPS-TAC.h"
#include "NGAP_EPS-TAI.h"
#include "NGAP_EquivalentPLMNs.h"
#include "NGAP_E-RAB-ID.h"
#include "NGAP_E-RABInformationItem.h"
#include "NGAP_E-RABInformationList.h"
#include "NGAP_ErrorIndication.h"
#include "NGAP_EUTRACellIdentity.h"
#include "NGAP_EUTRA-CGI.h"
#include "NGAP_EUTRA-CGIListForWarning.h"
#include "NGAP_EUTRA-CGIList.h"
#include "NGAP_EUTRAencryptionAlgorithms.h"
#include "NGAP_EUTRAintegrityProtectionAlgorithms.h"
#include "NGAP_EUTRAN-CellReportItem.h"
#include "NGAP_EUTRAN-CellReportList.h"
#include "NGAP_EUTRAN-CellToReportItem.h"
#include "NGAP_EUTRAN-CellToReportList.h"
#include "NGAP_EUTRAN-CompositeAvailableCapacityGroup.h"
#include "NGAP_EUTRAN-NumberOfActiveUEs.h"
#include "NGAP_EUTRAN-RadioResourceStatus.h"
#include "NGAP_EUTRAN-ReportingStatusIEs.h"
#include "NGAP_EUTRAN-ReportingSystemIEs.h"
#include "NGAP_EUTRA-Paging-eDRX-Cycle.h"
#include "NGAP_EUTRA-PagingeDRXInformation.h"
#include "NGAP_EUTRA-Paging-Time-Window.h"
#include "NGAP_EventBasedReportingIEs.h"
#include "NGAP_EventL1LoggedMDTConfig.h"
#include "NGAP_EventTrigger.h"
#include "NGAP_EventType.h"
#include "NGAP_ExcessPacketDelayThresholdConfiguration.h"
#include "NGAP_ExcessPacketDelayThresholdItem.h"
#include "NGAP_ExcessPacketDelayThresholdValue.h"
#include "NGAP_ExpectedActivityPeriod.h"
#include "NGAP_ExpectedHOInterval.h"
#include "NGAP_ExpectedIdlePeriod.h"
#include "NGAP_ExpectedUEActivityBehaviour.h"
#include "NGAP_ExpectedUEBehaviour.h"
#include "NGAP_ExpectedUEMobility.h"
#include "NGAP_ExpectedUEMovingTrajectory.h"
#include "NGAP_ExpectedUEMovingTrajectoryItem.h"
#include "NGAP_Extended-AMFName.h"
#include "NGAP_Extended-ConnectedTime.h"
#include "NGAP_ExtendedPacketDelayBudget.h"
#include "NGAP_Extended-RANNodeName.h"
#include "NGAP_ExtendedRATRestrictionInformation.h"
#include "NGAP_ExtendedReportIntervalMDT.h"
#include "NGAP_ExtendedRNC-ID.h"
#include "NGAP_ExtendedSliceSupportList.h"
#include "NGAP_ExtendedUEIdentityIndexValue.h"
#include "NGAP_EXTERNAL.h"
#include "NGAP_FailureIndication.h"
#include "NGAP_FirstDLCount.h"
#include "NGAP_FiveG-ProSeAuthorized.h"
#include "NGAP_FiveGProSeDirectCommunication.h"
#include "NGAP_FiveGProSeDirectDiscovery.h"
#include "NGAP_FiveGProSeLayer2RemoteUE.h"
#include "NGAP_FiveGProSeLayer2UEtoNetworkRelay.h"
#include "NGAP_FiveGProSeLayer3UEtoNetworkRelay.h"
#include "NGAP_FiveGProSePC5FlowBitRates.h"
#include "NGAP_FiveGProSePC5QoSFlowItem.h"
#include "NGAP_FiveGProSePC5QoSFlowList.h"
#include "NGAP_FiveG-ProSePC5QoSParameters.h"
#include "NGAP_FiveG-S-TMSI.h"
#include "NGAP_FiveG-TMSI.h"
#include "NGAP_FiveQI.h"
#include "NGAP_ForbiddenAreaInformation.h"
#include "NGAP_ForbiddenAreaInformation-Item.h"
#include "NGAP_ForbiddenTACs.h"
#include "NGAP_FromEUTRANtoNGRAN.h"
#include "NGAP_FromNGRANtoEUTRAN.h"
#include "NGAP_GBR-QosInformation.h"
#include "NGAP_GlobalCable-ID.h"
#include "NGAP_GlobalENB-ID.h"
#include "NGAP_GlobalGNB-ID.h"
#include "NGAP_GlobalLineIdentity.h"
#include "NGAP_GlobalLine-ID.h"
#include "NGAP_GlobalN3IWF-ID.h"
#include "NGAP_GlobalNgENB-ID.h"
#include "NGAP_GlobalRANNodeID.h"
#include "NGAP_GlobalTNGF-ID.h"
#include "NGAP_GlobalTWIF-ID.h"
#include "NGAP_GlobalW-AGF-ID.h"
#include "NGAP_GNB-ID.h"
#include "NGAP_GNBSetID.h"
#include "NGAP_GTP-TEID.h"
#include "NGAP_GTPTunnel.h"
#include "NGAP_GUAMI.h"
#include "NGAP_GUAMIType.h"
#include "NGAP_HandoverCancelAcknowledge.h"
#include "NGAP_HandoverCancel.h"
#include "NGAP_HandoverCommand.h"
#include "NGAP_HandoverCommandTransfer.h"
#include "NGAP_HandoverFailure.h"
#include "NGAP_HandoverFlag.h"
#include "NGAP_HandoverNotify.h"
#include "NGAP_HandoverPreparationFailure.h"
#include "NGAP_HandoverPreparationUnsuccessfulTransfer.h"
#include "NGAP_HandoverRequestAcknowledge.h"
#include "NGAP_HandoverRequestAcknowledgeTransfer.h"
#include "NGAP_HandoverRequest.h"
#include "NGAP_HandoverRequired.h"
#include "NGAP_HandoverRequiredTransfer.h"
#include "NGAP_HandoverResourceAllocationUnsuccessfulTransfer.h"
#include "NGAP_HandoverSuccess.h"
#include "NGAP_HandoverType.h"
#include "NGAP_HFCNode-ID.h"
#include "NGAP_HOReport.h"
#include "NGAP_Hysteresis.h"
#include "NGAP_IAB-Authorized.h"
#include "NGAP_IABNodeIndication.h"
#include "NGAP_IAB-Supported.h"
#include "NGAP_ImmediateMDTNr.h"
#include "NGAP_IMSVoiceSupportIndicator.h"
#include "NGAP_IncludeBeamMeasurementsIndication.h"
#include "NGAP_IndexToRFSP.h"
#include "NGAP_InfoOnRecommendedCellsAndRANNodesForPaging.h"
#include "NGAP_InitialContextSetupFailure.h"
#include "NGAP_InitialContextSetupRequest.h"
#include "NGAP_InitialContextSetupResponse.h"
#include "NGAP_InitialUEMessage.h"
#include "NGAP_InitiatingMessage.h"
#include "NGAP_IntegrityProtectionIndication.h"
#include "NGAP_IntegrityProtectionResult.h"
#include "NGAP_IntendedNumberOfPagingAttempts.h"
#include "NGAP_InterfacesToTrace.h"
#include "NGAP_IntersystemCellActivationReply.h"
#include "NGAP_IntersystemCellActivationRequest.h"
#include "NGAP_IntersystemCellStateIndication.h"
#include "NGAP_InterSystemFailureIndication.h"
#include "NGAP_InterSystemHandoverReportType.h"
#include "NGAP_InterSystemHOReport.h"
#include "NGAP_IntersystemResourceStatusReply.h"
#include "NGAP_IntersystemResourceStatusReport.h"
#include "NGAP_IntersystemResourceStatusRequest.h"
#include "NGAP_IntersystemResourceThreshold.h"
#include "NGAP_IntersystemSONConfigurationTransfer.h"
#include "NGAP_IntersystemSONeNBID.h"
#include "NGAP_IntersystemSONInformation.h"
#include "NGAP_IntersystemSONInformationReply.h"
#include "NGAP_IntersystemSONInformationReport.h"
#include "NGAP_IntersystemSONInformationRequest.h"
#include "NGAP_IntersystemSONNGRANnodeID.h"
#include "NGAP_IntersystemSONTransferType.h"
#include "NGAP_IntersystemUnnecessaryHO.h"
#include "NGAP_LAC.h"
#include "NGAP_LAI.h"
#include "NGAP_LastVisitedCellInformation.h"
#include "NGAP_LastVisitedCellItem.h"
#include "NGAP_LastVisitedEUTRANCellInformation.h"
#include "NGAP_LastVisitedGERANCellInformation.h"
#include "NGAP_LastVisitedNGRANCellInformation.h"
#include "NGAP_LastVisitedPSCellInformation.h"
#include "NGAP_LastVisitedPSCellList.h"
#include "NGAP_LastVisitedUTRANCellInformation.h"
#include "NGAP_LineType.h"
#include "NGAP_Links-to-log.h"
#include "NGAP_LocationReport.h"
#include "NGAP_LocationReportingAdditionalInfo.h"
#include "NGAP_LocationReportingControl.h"
#include "NGAP_LocationReportingFailureIndication.h"
#include "NGAP_LocationReportingReferenceID.h"
#include "NGAP_LocationReportingRequestType.h"
#include "NGAP_LoggedMDTNr.h"
#include "NGAP_LoggedMDTTrigger.h"
#include "NGAP_LoggingDuration.h"
#include "NGAP_LoggingInterval.h"
#include "NGAP_LTEM-Indication.h"
#include "NGAP_LTEUERLFReportContainer.h"
#include "NGAP_LTEUESidelinkAggregateMaximumBitrate.h"
#include "NGAP_LTEV2XServicesAuthorized.h"
#include "NGAP_M1Configuration.h"
#include "NGAP_M1PeriodicReporting.h"
#include "NGAP_M1ReportingTrigger.h"
#include "NGAP_M1ThresholdEventA2.h"
#include "NGAP_M1ThresholdType.h"
#include "NGAP_M4Configuration.h"
#include "NGAP_M4period.h"
#include "NGAP_M4ReportAmountMDT.h"
#include "NGAP_M5Configuration.h"
#include "NGAP_M5period.h"
#include "NGAP_M5ReportAmountMDT.h"
#include "NGAP_M6Configuration.h"
#include "NGAP_M6ReportAmountMDT.h"
#include "NGAP_M6report-Interval.h"
#include "NGAP_M7Configuration.h"
#include "NGAP_M7period.h"
#include "NGAP_M7ReportAmountMDT.h"
#include "NGAP_MaskedIMEISV.h"
#include "NGAP_MaximumDataBurstVolume.h"
#include "NGAP_MaximumIntegrityProtectedDataRate.h"
#include "NGAP_MaxNrofRS-IndexesToReport.h"
#include "NGAP_MBS-ActiveSessionInformation-SourcetoTargetItem.h"
#include "NGAP_MBS-ActiveSessionInformation-SourcetoTargetList.h"
#include "NGAP_MBS-ActiveSessionInformation-TargettoSourceItem.h"
#include "NGAP_MBS-ActiveSessionInformation-TargettoSourceList.h"
#include "NGAP_MBS-AreaSessionID.h"
#include "NGAP_MBS-AreaTAIList.h"
#include "NGAP_MBS-DataForwardingResponseMRBItem.h"
#include "NGAP_MBS-DataForwardingResponseMRBList.h"
#include "NGAP_MBS-DistributionReleaseRequestTransfer.h"
#include "NGAP_MBS-DistributionSetupRequestTransfer.h"
#include "NGAP_MBS-DistributionSetupResponseTransfer.h"
#include "NGAP_MBS-DistributionSetupUnsuccessfulTransfer.h"
#include "NGAP_MBS-MappingandDataForwardingRequestItem.h"
#include "NGAP_MBS-MappingandDataForwardingRequestList.h"
#include "NGAP_MBS-QoSFlowList.h"
#include "NGAP_MBS-QoSFlowsToBeSetupItem.h"
#include "NGAP_MBS-QoSFlowsToBeSetupList.h"
#include "NGAP_MBS-ServiceAreaCellList.h"
#include "NGAP_MBS-ServiceArea.h"
#include "NGAP_MBS-ServiceAreaInformation.h"
#include "NGAP_MBS-ServiceAreaInformationItem.h"
#include "NGAP_MBS-ServiceAreaInformationList.h"
#include "NGAP_MBS-ServiceAreaTAIList.h"
#include "NGAP_MBSSessionFailedtoSetupItem.h"
#include "NGAP_MBSSessionFailedtoSetupList.h"
#include "NGAP_MBS-SessionFSAID.h"
#include "NGAP_MBS-SessionFSAIDList.h"
#include "NGAP_MBS-SessionID.h"
#include "NGAP_MBSSessionReleaseResponseTransfer.h"
#include "NGAP_MBSSessionSetupOrModFailureTransfer.h"
#include "NGAP_MBSSessionSetuporModifyRequestItem.h"
#include "NGAP_MBSSessionSetuporModifyRequestList.h"
#include "NGAP_MBSSessionSetupOrModRequestTransfer.h"
#include "NGAP_MBSSessionSetupOrModResponseTransfer.h"
#include "NGAP_MBSSessionSetupRequestItem.h"
#include "NGAP_MBSSessionSetupRequestList.h"
#include "NGAP_MBSSessionSetupResponseItem.h"
#include "NGAP_MBSSessionSetupResponseList.h"
#include "NGAP_MBSSessionStatus.h"
#include "NGAP_MBS-SessionTNLInfo5GC.h"
#include "NGAP_MBS-SessionTNLInfo5GCItem.h"
#include "NGAP_MBS-SessionTNLInfo5GCList.h"
#include "NGAP_MBS-SessionTNLInfoNGRAN.h"
#include "NGAP_MBS-SessionTNLInfoNGRANItem.h"
#include "NGAP_MBS-SessionTNLInfoNGRANList.h"
#include "NGAP_MBSSessionToReleaseItem.h"
#include "NGAP_MBSSessionToReleaseList.h"
#include "NGAP_MBS-SupportIndicator.h"
#include "NGAP_MDT-Activation.h"
#include "NGAP_MDT-AlignmentInfo.h"
#include "NGAP_MDT-Configuration-EUTRA.h"
#include "NGAP_MDT-Configuration.h"
#include "NGAP_MDT-Configuration-NR.h"
#include "NGAP_MDT-Location-Info.h"
#include "NGAP_MDT-Location-Information.h"
#include "NGAP_MDTModeEutra.h"
#include "NGAP_MDTModeNr.h"
#include "NGAP_MDTPLMNList.h"
#include "NGAP_MDTPLMNModificationList.h"
#include "NGAP_MeasurementsToActivate.h"
#include "NGAP_MeasurementThresholdL1LoggedMDT.h"
#include "NGAP_MessageIdentifier.h"
#include "NGAP_MicoAllPLMN.h"
#include "NGAP_MICOModeIndication.h"
#include "NGAP_MobilityInformation.h"
#include "NGAP_MobilityRestrictionList.h"
#include "NGAP_MRB-ID.h"
#include "NGAP_MRB-ProgressInformation.h"
#include "NGAP_MulticastGroupPagingArea.h"
#include "NGAP_MulticastGroupPagingAreaItem.h"
#include "NGAP_MulticastGroupPagingAreaList.h"
#include "NGAP_MulticastGroupPaging.h"
#include "NGAP_MulticastSessionActivationFailure.h"
#include "NGAP_MulticastSessionActivationRequest.h"
#include "NGAP_MulticastSessionActivationRequestTransfer.h"
#include "NGAP_MulticastSessionActivationResponse.h"
#include "NGAP_MulticastSessionDeactivationRequest.h"
#include "NGAP_MulticastSessionDeactivationRequestTransfer.h"
#include "NGAP_MulticastSessionDeactivationResponse.h"
#include "NGAP_MulticastSessionUpdateFailure.h"
#include "NGAP_MulticastSessionUpdateRequest.h"
#include "NGAP_MulticastSessionUpdateRequestTransfer.h"
#include "NGAP_MulticastSessionUpdateResponse.h"
#include "NGAP_N3IWF-ID.h"
#include "NGAP_NASNonDeliveryIndication.h"
#include "NGAP_NAS-PDU.h"
#include "NGAP_NASSecurityParametersFromNGRAN.h"
#include "NGAP_NB-IoT-DefaultPagingDRX.h"
#include "NGAP_NB-IoT-PagingDRX.h"
#include "NGAP_NB-IoT-Paging-eDRXCycle.h"
#include "NGAP_NB-IoT-Paging-eDRXInfo.h"
#include "NGAP_NB-IoT-Paging-TimeWindow.h"
#include "NGAP_NB-IoT-UEPriority.h"
#include "NGAP_NetworkInstance.h"
#include "NGAP_NewSecurityContextInd.h"
#include "NGAP_NextHopChainingCount.h"
#include "NGAP_NextPagingAreaScope.h"
#include "NGAP_NGAPIESupportInformationRequestItem.h"
#include "NGAP_NGAPIESupportInformationRequestList.h"
#include "NGAP_NGAPIESupportInformationResponseItem.h"
#include "NGAP_NGAPIESupportInformationResponseList.h"
#include "NGAP_NGAP-PDU.h"
#include "NGAP_NgENB-ID.h"
#include "NGAP_NGRAN-CellReportItem.h"
#include "NGAP_NGRAN-CellReportList.h"
#include "NGAP_NGRAN-CellToReportItem.h"
#include "NGAP_NGRAN-CellToReportList.h"
#include "NGAP_NGRAN-CGI.h"
#include "NGAP_NGRAN-NoofRRCConnections.h"
#include "NGAP_NGRAN-NumberOfActiveUEs.h"
#include "NGAP_NGRAN-RadioResourceStatus.h"
#include "NGAP_NGRAN-ReportingStatusIEs.h"
#include "NGAP_NGRAN-ReportingSystemIEs.h"
#include "NGAP_NGRAN-TNLAssociationToRemoveItem.h"
#include "NGAP_NGRAN-TNLAssociationToRemoveList.h"
#include "NGAP_NGRANTraceID.h"
#include "NGAP_NGResetAcknowledge.h"
#include "NGAP_NGReset.h"
#include "NGAP_NGSetupFailure.h"
#include "NGAP_NGSetupRequest.h"
#include "NGAP_NGSetupResponse.h"
#include "NGAP_NID.h"
#include "NGAP_NonDynamic5QIDescriptor.h"
#include "NGAP_NotAllowedTACs.h"
#include "NGAP_NotificationCause.h"
#include "NGAP_NotificationCell-Item.h"
#include "NGAP_NotificationCellList.h"
#include "NGAP_NotificationControl.h"
#include "NGAP_NotifySourceNGRANNode.h"
#include "NGAP_NPN-AccessInformation.h"
#include "NGAP_NPN-MobilityInformation.h"
#include "NGAP_NPN-PagingAssistanceInformation.h"
#include "NGAP_NPN-Support.h"
#include "NGAP_NRARFCN.h"
#include "NGAP_NRCellIdentity.h"
#include "NGAP_NR-CGI.h"
#include "NGAP_NR-CGIListForWarning.h"
#include "NGAP_NR-CGIList.h"
#include "NGAP_NRencryptionAlgorithms.h"
#include "NGAP_NRFrequencyBand.h"
#include "NGAP_NRFrequencyBandItem.h"
#include "NGAP_NRFrequencyBand-List.h"
#include "NGAP_NRFrequencyInfo.h"
#include "NGAP_NRintegrityProtectionAlgorithms.h"
#include "NGAP_NRMobilityHistoryReport.h"
#include "NGAP_NRNTNTAIInformation.h"
#include "NGAP_NR-Paging-eDRX-Cycle.h"
#include "NGAP_NR-PagingeDRXInformation.h"
#include "NGAP_NR-Paging-Time-Window.h"
#include "NGAP_NR-PCI.h"
#include "NGAP_NRPPa-PDU.h"
#include "NGAP_NRUERLFReportContainer.h"
#include "NGAP_NRUESidelinkAggregateMaximumBitrate.h"
#include "NGAP_NRV2XServicesAuthorized.h"
#include "NGAP_NSAG-ID.h"
#include "NGAP_NumberOfBroadcasts.h"
#include "NGAP_NumberOfBroadcastsRequested.h"
#include "NGAP_NumberOfMeasurementReportingLevels.h"
#include "NGAP_OnboardingSupport.h"
#include "NGAP_OverloadAction.h"
#include "NGAP_OverloadResponse.h"
#include "NGAP_OverloadStart.h"
#include "NGAP_OverloadStartNSSAIItem.h"
#include "NGAP_OverloadStartNSSAIList.h"
#include "NGAP_OverloadStop.h"
#include "NGAP_PacketDelayBudget.h"
#include "NGAP_PacketErrorRate.h"
#include "NGAP_PacketLossRate.h"
#include "NGAP_PagingAssisDataforCEcapabUE.h"
#include "NGAP_PagingAttemptCount.h"
#include "NGAP_PagingAttemptInformation.h"
#include "NGAP_PagingCause.h"
#include "NGAP_PagingCauseIndicationForVoiceService.h"
#include "NGAP_PagingDRX.h"
#include "NGAP_Paging-eDRX-Cycle.h"
#include "NGAP_PagingeDRXInformation.h"
#include "NGAP_Paging.h"
#include "NGAP_PagingOrigin.h"
#include "NGAP_PagingPriority.h"
#include "NGAP_PagingProbabilityInformation.h"
#include "NGAP_Paging-Time-Window.h"
#include "NGAP_PathSwitchRequestAcknowledge.h"
#include "NGAP_PathSwitchRequestAcknowledgeTransfer.h"
#include "NGAP_PathSwitchRequestFailure.h"
#include "NGAP_PathSwitchRequest.h"
#include "NGAP_PathSwitchRequestSetupFailedTransfer.h"
#include "NGAP_PathSwitchRequestTransfer.h"
#include "NGAP_PathSwitchRequestUnsuccessfulTransfer.h"
#include "NGAP_PC5FlowBitRates.h"
#include "NGAP_PC5QoSFlowItem.h"
#include "NGAP_PC5QoSFlowList.h"
#include "NGAP_PC5QoSParameters.h"
#include "NGAP_PCIListForMDT.h"
#include "NGAP_PDUSessionAggregateMaximumBitRate.h"
#include "NGAP_PDUSessionID.h"
#include "NGAP_PDUSessionPairID.h"
#include "NGAP_PDUSessionResourceAdmittedItem.h"
#include "NGAP_PDUSessionResourceAdmittedList.h"
#include "NGAP_PDUSessionResourceFailedToModifyItemModCfm.h"
#include "NGAP_PDUSessionResourceFailedToModifyItemModRes.h"
#include "NGAP_PDUSessionResourceFailedToModifyListModCfm.h"
#include "NGAP_PDUSessionResourceFailedToModifyListModRes.h"
#include "NGAP_PDUSessionResourceFailedToResumeItemRESReq.h"
#include "NGAP_PDUSessionResourceFailedToResumeItemRESRes.h"
#include "NGAP_PDUSessionResourceFailedToResumeListRESReq.h"
#include "NGAP_PDUSessionResourceFailedToResumeListRESRes.h"
#include "NGAP_PDUSessionResourceFailedToSetupItemCxtFail.h"
#include "NGAP_PDUSessionResourceFailedToSetupItemCxtRes.h"
#include "NGAP_PDUSessionResourceFailedToSetupItemHOAck.h"
#include "NGAP_PDUSessionResourceFailedToSetupItemPSReq.h"
#include "NGAP_PDUSessionResourceFailedToSetupItemSURes.h"
#include "NGAP_PDUSessionResourceFailedToSetupListCxtFail.h"
#include "NGAP_PDUSessionResourceFailedToSetupListCxtRes.h"
#include "NGAP_PDUSessionResourceFailedToSetupListHOAck.h"
#include "NGAP_PDUSessionResourceFailedToSetupListPSReq.h"
#include "NGAP_PDUSessionResourceFailedToSetupListSURes.h"
#include "NGAP_PDUSessionResourceHandoverItem.h"
#include "NGAP_PDUSessionResourceHandoverList.h"
#include "NGAP_PDUSessionResourceInformationItem.h"
#include "NGAP_PDUSessionResourceInformationList.h"
#include "NGAP_PDUSessionResourceItemCxtRelCpl.h"
#include "NGAP_PDUSessionResourceItemCxtRelReq.h"
#include "NGAP_PDUSessionResourceItemHORqd.h"
#include "NGAP_PDUSessionResourceListCxtRelCpl.h"
#include "NGAP_PDUSessionResourceListCxtRelReq.h"
#include "NGAP_PDUSessionResourceListHORqd.h"
#include "NGAP_PDUSessionResourceModifyConfirm.h"
#include "NGAP_PDUSessionResourceModifyConfirmTransfer.h"
#include "NGAP_PDUSessionResourceModifyIndication.h"
#include "NGAP_PDUSessionResourceModifyIndicationTransfer.h"
#include "NGAP_PDUSessionResourceModifyIndicationUnsuccessfulTransfer.h"
#include "NGAP_PDUSessionResourceModifyItemModCfm.h"
#include "NGAP_PDUSessionResourceModifyItemModInd.h"
#include "NGAP_PDUSessionResourceModifyItemModReq.h"
#include "NGAP_PDUSessionResourceModifyItemModRes.h"
#include "NGAP_PDUSessionResourceModifyListModCfm.h"
#include "NGAP_PDUSessionResourceModifyListModInd.h"
#include "NGAP_PDUSessionResourceModifyListModReq.h"
#include "NGAP_PDUSessionResourceModifyListModRes.h"
#include "NGAP_PDUSessionResourceModifyRequest.h"
#include "NGAP_PDUSessionResourceModifyRequestTransfer.h"
#include "NGAP_PDUSessionResourceModifyResponse.h"
#include "NGAP_PDUSessionResourceModifyResponseTransfer.h"
#include "NGAP_PDUSessionResourceModifyUnsuccessfulTransfer.h"
#include "NGAP_PDUSessionResourceNotify.h"
#include "NGAP_PDUSessionResourceNotifyItem.h"
#include "NGAP_PDUSessionResourceNotifyList.h"
#include "NGAP_PDUSessionResourceNotifyReleasedTransfer.h"
#include "NGAP_PDUSessionResourceNotifyTransfer.h"
#include "NGAP_PDUSessionResourceReleaseCommand.h"
#include "NGAP_PDUSessionResourceReleaseCommandTransfer.h"
#include "NGAP_PDUSessionResourceReleasedItemNot.h"
#include "NGAP_PDUSessionResourceReleasedItemPSAck.h"
#include "NGAP_PDUSessionResourceReleasedItemPSFail.h"
#include "NGAP_PDUSessionResourceReleasedItemRelRes.h"
#include "NGAP_PDUSessionResourceReleasedListNot.h"
#include "NGAP_PDUSessionResourceReleasedListPSAck.h"
#include "NGAP_PDUSessionResourceReleasedListPSFail.h"
#include "NGAP_PDUSessionResourceReleasedListRelRes.h"
#include "NGAP_PDUSessionResourceReleaseResponse.h"
#include "NGAP_PDUSessionResourceReleaseResponseTransfer.h"
#include "NGAP_PDUSessionResourceResumeItemRESReq.h"
#include "NGAP_PDUSessionResourceResumeItemRESRes.h"
#include "NGAP_PDUSessionResourceResumeListRESReq.h"
#include "NGAP_PDUSessionResourceResumeListRESRes.h"
#include "NGAP_PDUSessionResourceSecondaryRATUsageItem.h"
#include "NGAP_PDUSessionResourceSecondaryRATUsageList.h"
#include "NGAP_PDUSessionResourceSetupItemCxtReq.h"
#include "NGAP_PDUSessionResourceSetupItemCxtRes.h"
#include "NGAP_PDUSessionResourceSetupItemHOReq.h"
#include "NGAP_PDUSessionResourceSetupItemSUReq.h"
#include "NGAP_PDUSessionResourceSetupItemSURes.h"
#include "NGAP_PDUSessionResourceSetupListCxtReq.h"
#include "NGAP_PDUSessionResourceSetupListCxtRes.h"
#include "NGAP_PDUSessionResourceSetupListHOReq.h"
#include "NGAP_PDUSessionResourceSetupListSUReq.h"
#include "NGAP_PDUSessionResourceSetupListSURes.h"
#include "NGAP_PDUSessionResourceSetupRequest.h"
#include "NGAP_PDUSessionResourceSetupRequestTransfer.h"
#include "NGAP_PDUSessionResourceSetupResponse.h"
#include "NGAP_PDUSessionResourceSetupResponseTransfer.h"
#include "NGAP_PDUSessionResourceSetupUnsuccessfulTransfer.h"
#include "NGAP_PDUSessionResourceSuspendItemSUSReq.h"
#include "NGAP_PDUSessionResourceSuspendListSUSReq.h"
#include "NGAP_PDUSessionResourceSwitchedItem.h"
#include "NGAP_PDUSessionResourceSwitchedList.h"
#include "NGAP_PDUSessionResourceToBeSwitchedDLItem.h"
#include "NGAP_PDUSessionResourceToBeSwitchedDLList.h"
#include "NGAP_PDUSessionResourceToReleaseItemHOCmd.h"
#include "NGAP_PDUSessionResourceToReleaseItemRelCmd.h"
#include "NGAP_PDUSessionResourceToReleaseListHOCmd.h"
#include "NGAP_PDUSessionResourceToReleaseListRelCmd.h"
#include "NGAP_PDUSessionType.h"
#include "NGAP_PDUSessionUsageReport.h"
#include "NGAP_PedestrianUE.h"
#include "NGAP_PEIPSassistanceInformation.h"
#include "NGAP_Periodicity.h"
#include "NGAP_PeriodicRegistrationUpdateTimer.h"
#include "NGAP_PeriodicReportingIEs.h"
#include "NGAP_PLMNAreaBasedQMC.h"
#include "NGAP_PLMNIdentity.h"
#include "NGAP_PLMNListforQMC.h"
#include "NGAP_PLMNSupportItem.h"
#include "NGAP_PLMNSupportList.h"
#include "NGAP_PNI-NPN-MobilityInformation.h"
#include "NGAP_PortNumber.h"
#include "NGAP_Pre-emptionCapability.h"
#include "NGAP_Pre-emptionVulnerability.h"
#include "NGAP_Presence.h"
#include "NGAP_PriorityLevelARP.h"
#include "NGAP_PriorityLevelQos.h"
#include "NGAP_PrivacyIndicator.h"
#include "NGAP_PrivateIE-Container.h"
#include "NGAP_PrivateIE-Field.h"
#include "NGAP_PrivateIE-ID.h"
#include "NGAP_PrivateMessage.h"
#include "NGAP_ProcedureCode.h"
#include "NGAP_ProcedureStageChoice.h"
#include "NGAP_ProtocolExtensionContainer.h"
#include "NGAP_ProtocolExtensionField.h"
#include "NGAP_ProtocolExtensionID.h"
#include "NGAP_ProtocolIE-Container.h"
#include "NGAP_ProtocolIE-ContainerList.h"
#include "NGAP_ProtocolIE-Field.h"
#include "NGAP_ProtocolIE-ID.h"
#include "NGAP_ProtocolIE-SingleContainer.h"
#include "NGAP_PWSCancelRequest.h"
#include "NGAP_PWSCancelResponse.h"
#include "NGAP_PWSFailedCellIDList.h"
#include "NGAP_PWSFailureIndication.h"
#include "NGAP_PWSRestartIndication.h"
#include "NGAP_QMCConfigInfo.h"
#include "NGAP_QMCDeactivation.h"
#include "NGAP_QoEReference.h"
#include "NGAP_QoEReferenceList.h"
#include "NGAP_QosCharacteristics.h"
#include "NGAP_QosFlowAcceptedItem.h"
#include "NGAP_QosFlowAcceptedList.h"
#include "NGAP_QosFlowAddOrModifyRequestItem.h"
#include "NGAP_QosFlowAddOrModifyRequestList.h"
#include "NGAP_QosFlowAddOrModifyResponseItem.h"
#include "NGAP_QosFlowAddOrModifyResponseList.h"
#include "NGAP_QosFlowFeedbackItem.h"
#include "NGAP_QosFlowFeedbackList.h"
#include "NGAP_QosFlowIdentifier.h"
#include "NGAP_QosFlowInformationItem.h"
#include "NGAP_QosFlowInformationList.h"
#include "NGAP_QosFlowItemWithDataForwarding.h"
#include "NGAP_QosFlowLevelQosParameters.h"
#include "NGAP_QoSFlowList.h"
#include "NGAP_QosFlowListWithCause.h"
#include "NGAP_QosFlowListWithDataForwarding.h"
#include "NGAP_QosFlowModifyConfirmItem.h"
#include "NGAP_QosFlowModifyConfirmList.h"
#include "NGAP_QosFlowNotifyItem.h"
#include "NGAP_QosFlowNotifyList.h"
#include "NGAP_QosFlowParametersItem.h"
#include "NGAP_QosFlowParametersList.h"
#include "NGAP_QosFlowPerTNLInformation.h"
#include "NGAP_QosFlowPerTNLInformationItem.h"
#include "NGAP_QosFlowPerTNLInformationList.h"
#include "NGAP_QosFlowSetupRequestItem.h"
#include "NGAP_QosFlowSetupRequestList.h"
#include "NGAP_QoSFlowsUsageReport-Item.h"
#include "NGAP_QoSFlowsUsageReportList.h"
#include "NGAP_QosFlowToBeForwardedItem.h"
#include "NGAP_QosFlowToBeForwardedList.h"
#include "NGAP_QosFlowWithCauseItem.h"
#include "NGAP_QosMonitoringReportingFrequency.h"
#include "NGAP_QosMonitoringRequest.h"
#include "NGAP_RANConfigurationUpdateAcknowledge.h"
#include "NGAP_RANConfigurationUpdateFailure.h"
#include "NGAP_RANConfigurationUpdate.h"
#include "NGAP_RANCPRelocationIndication.h"
#include "NGAP_Range.h"
#include "NGAP_RANNodeName.h"
#include "NGAP_RANNodeNameUTF8String.h"
#include "NGAP_RANNodeNameVisibleString.h"
#include "NGAP_RANPagingPriority.h"
#include "NGAP_RANStatusTransfer-TransparentContainer.h"
#include "NGAP_RAN-UE-NGAP-ID.h"
#include "NGAP_RAT-Information.h"
#include "NGAP_RATRestrictionInformation.h"
#include "NGAP_RATRestrictions.h"
#include "NGAP_RATRestrictions-Item.h"
#include "NGAP_RecommendedCellItem.h"
#include "NGAP_RecommendedCellList.h"
#include "NGAP_RecommendedCellsForPaging.h"
#include "NGAP_RecommendedRANNodeItem.h"
#include "NGAP_RecommendedRANNodeList.h"
#include "NGAP_RecommendedRANNodesForPaging.h"
#include "NGAP_RedCapIndication.h"
#include "NGAP_RedirectionVoiceFallback.h"
#include "NGAP_RedundantPDUSessionInformation.h"
#include "NGAP_RedundantQosFlowIndicator.h"
#include "NGAP_ReflectiveQosAttribute.h"
#include "NGAP_RejectedNSSAIinPLMN.h"
#include "NGAP_RejectedNSSAIinTA.h"
#include "NGAP_RelativeAMFCapacity.h"
#include "NGAP_RepetitionPeriod.h"
#include "NGAP_ReportAmountMDT.h"
#include "NGAP_ReportArea.h"
#include "NGAP_ReportCharacteristics.h"
#include "NGAP_ReportingPeriodicity.h"
#include "NGAP_ReportingSystem.h"
#include "NGAP_ReportIntervalMDT.h"
#include "NGAP_ReportType.h"
#include "NGAP_RerouteNASRequest.h"
#include "NGAP_ResetAll.h"
#include "NGAP_ResetType.h"
#include "NGAP_ResourceStatusReportingSystem.h"
#include "NGAP_RetrieveUEInformation.h"
#include "NGAP_RGLevelWirelineAccessCharacteristics.h"
#include "NGAP_RIMInformation.h"
#include "NGAP_RIMInformationTransfer.h"
#include "NGAP_RNC-ID.h"
#include "NGAP_RoutingID.h"
#include "NGAP_RRCContainer.h"
#include "NGAP_RRCEstablishmentCause.h"
#include "NGAP_RRCInactiveTransitionReport.h"
#include "NGAP_RRCInactiveTransitionReportRequest.h"
#include "NGAP_RRCState.h"
#include "NGAP_RSN.h"
#include "NGAP_ScheduledCommunicationTime.h"
#include "NGAP_SCTP-TLAs.h"
#include "NGAP_SD.h"
#include "NGAP_SecondaryRATDataUsageReport.h"
#include "NGAP_SecondaryRATDataUsageReportTransfer.h"
#include "NGAP_SecondaryRATUsageInformation.h"
#include "NGAP_SecurityContext.h"
#include "NGAP_SecurityIndication.h"
#include "NGAP_SecurityKey.h"
#include "NGAP_SecurityResult.h"
#include "NGAP_SensorMeasConfig.h"
#include "NGAP_SensorMeasConfigNameItem.h"
#include "NGAP_SensorMeasConfigNameList.h"
#include "NGAP_SensorMeasurementConfiguration.h"
#include "NGAP_SensorNameConfig.h"
#include "NGAP_SerialNumber.h"
#include "NGAP_ServedGUAMIItem.h"
#include "NGAP_ServedGUAMIList.h"
#include "NGAP_ServiceAreaInformation.h"
#include "NGAP_ServiceAreaInformation-Item.h"
#include "NGAP_ServiceType.h"
#include "NGAP_SgNB-UE-X2AP-ID.h"
#include "NGAP_SharedNGU-MulticastTNLInformation.h"
#include "NGAP_SliceOverloadItem.h"
#include "NGAP_SliceOverloadList.h"
#include "NGAP_SliceSupportItem.h"
#include "NGAP_SliceSupportList.h"
#include "NGAP_SliceSupportListQMC.h"
#include "NGAP_SliceSupportQMC-Item.h"
#include "NGAP_SNPN-MobilityInformation.h"
#include "NGAP_S-NSSAI.h"
#include "NGAP_SONConfigurationTransfer.h"
#include "NGAP_SONInformation.h"
#include "NGAP_SONInformationReply.h"
#include "NGAP_SONInformationReport.h"
#include "NGAP_SONInformationRequest.h"
#include "NGAP_SourceNGRANNode-ToTargetNGRANNode-TransparentContainer.h"
#include "NGAP_SourceNodeID.h"
#include "NGAP_SourceOfUEActivityBehaviourInformation.h"
#include "NGAP_SourceRANNodeID.h"
#include "NGAP_SourceToTarget-AMFInformationReroute.h"
#include "NGAP_SourceToTarget-TransparentContainer.h"
#include "NGAP_SRVCCOperationPossible.h"
#include "NGAP_SST.h"
#include "NGAP_SuccessfulHandoverReport-Item.h"
#include "NGAP_SuccessfulHandoverReportList.h"
#include "NGAP_SuccessfulOutcome.h"
#include "NGAP_SupportedTAItem.h"
#include "NGAP_SupportedTAList.h"
#include "NGAP_SurvivalTime.h"
#include "NGAP_SuspendIndicator.h"
#include "NGAP_Suspend-Request-Indication.h"
#include "NGAP_Suspend-Response-Indication.h"
#include "NGAP_TABasedMDT.h"
#include "NGAP_TABasedQMC.h"
#include "NGAP_TAC.h"
#include "NGAP_TACListInNRNTN.h"
#include "NGAP_TAIBasedMDT.h"
#include "NGAP_TAIBasedQMC.h"
#include "NGAP_TAIBroadcastEUTRA.h"
#include "NGAP_TAIBroadcastEUTRA-Item.h"
#include "NGAP_TAIBroadcastNR.h"
#include "NGAP_TAIBroadcastNR-Item.h"
#include "NGAP_TAICancelledEUTRA.h"
#include "NGAP_TAICancelledEUTRA-Item.h"
#include "NGAP_TAICancelledNR.h"
#include "NGAP_TAICancelledNR-Item.h"
#include "NGAP_TAI.h"
#include "NGAP_TAIListForInactive.h"
#include "NGAP_TAIListForInactiveItem.h"
#include "NGAP_TAIListforMDT.h"
#include "NGAP_TAIListForPaging.h"
#include "NGAP_TAIListForPagingItem.h"
#include "NGAP_TAIListforQMC.h"
#include "NGAP_TAIListForRestart.h"
#include "NGAP_TAIListForWarning.h"
#include "NGAP_TAINSAGSupportItem.h"
#include "NGAP_TAINSAGSupportList.h"
#include "NGAP_TAListforMDT.h"
#include "NGAP_TAListforQMC.h"
#include "NGAP_TargeteNB-ID.h"
#include "NGAP_TargetID.h"
#include "NGAP_TargetNGRANNode-ToSourceNGRANNode-FailureTransparentContainer.h"
#include "NGAP_TargetNGRANNode-ToSourceNGRANNode-TransparentContainer.h"
#include "NGAP_TargetNSSAI.h"
#include "NGAP_TargetNSSAIInformation.h"
#include "NGAP_TargetNSSAI-Item.h"
#include "NGAP_TargetRANNodeID.h"
#include "NGAP_TargetRNC-ID.h"
#include "NGAP_TargettoSource-Failure-TransparentContainer.h"
#include "NGAP_TargetToSource-TransparentContainer.h"
#include "NGAP_Threshold-RSRP.h"
#include "NGAP_Threshold-RSRQ.h"
#include "NGAP_Threshold-SINR.h"
#include "NGAP_TimerApproachForGUAMIRemoval.h"
#include "NGAP_TimeStamp.h"
#include "NGAP_TimeSyncAssistanceInfo.h"
#include "NGAP_TimeToTrigger.h"
#include "NGAP_TimeToWait.h"
#include "NGAP_TimeUEStayedInCellEnhancedGranularity.h"
#include "NGAP_TimeUEStayedInCell.h"
#include "NGAP_TMGI.h"
#include "NGAP_TNAP-ID.h"
#include "NGAP_TNGF-ID.h"
#include "NGAP_TNLAddressWeightFactor.h"
#include "NGAP_TNLAssociationItem.h"
#include "NGAP_TNLAssociationList.h"
#include "NGAP_TNLAssociationUsage.h"
#include "NGAP_TooearlyIntersystemHO.h"
#include "NGAP_TraceActivation.h"
#include "NGAP_TraceDepth.h"
#include "NGAP_TraceFailureIndication.h"
#include "NGAP_TraceStart.h"
#include "NGAP_TrafficLoadReductionIndication.h"
#include "NGAP_TransportLayerAddress.h"
#include "NGAP_TriggeringMessage.h"
#include "NGAP_TSCAssistanceInformation.h"
#include "NGAP_TSCTrafficCharacteristics.h"
#include "NGAP_TWAP-ID.h"
#include "NGAP_TWIF-ID.h"
#include "NGAP_TypeOfError.h"
#include "NGAP_UEAggregateMaximumBitRate.h"
#include "NGAP_UEAppLayerMeasConfigInfo.h"
#include "NGAP_UEAppLayerMeasInfoItem.h"
#include "NGAP_UEAppLayerMeasInfoList.h"
#include "NGAP_UE-associatedLogicalNG-connectionItem.h"
#include "NGAP_UE-associatedLogicalNG-connectionList.h"
#include "NGAP_UECapabilityInfoRequest.h"
#include "NGAP_UEContextModificationFailure.h"
#include "NGAP_UEContextModificationRequest.h"
#include "NGAP_UEContextModificationResponse.h"
#include "NGAP_UEContextReleaseCommand.h"
#include "NGAP_UEContextReleaseComplete.h"
#include "NGAP_UEContextReleaseRequest.h"
#include "NGAP_UEContextRequest.h"
#include "NGAP_UEContextResumeFailure.h"
#include "NGAP_UEContextResumeRequest.h"
#include "NGAP_UEContextResumeRequestTransfer.h"
#include "NGAP_UEContextResumeResponse.h"
#include "NGAP_UEContextResumeResponseTransfer.h"
#include "NGAP_UEContextSuspendFailure.h"
#include "NGAP_UEContextSuspendRequest.h"
#include "NGAP_UEContextSuspendRequestTransfer.h"
#include "NGAP_UEContextSuspendResponse.h"
#include "NGAP_UE-DifferentiationInfo.h"
#include "NGAP_UEHistoryInformationFromTheUE.h"
#include "NGAP_UEHistoryInformation.h"
#include "NGAP_UEIdentityIndexValue.h"
#include "NGAP_UEInformationTransfer.h"
#include "NGAP_UE-NGAP-ID-pair.h"
#include "NGAP_UE-NGAP-IDs.h"
#include "NGAP_UEPagingIdentity.h"
#include "NGAP_UE-PagingItem.h"
#include "NGAP_UE-PagingList.h"
#include "NGAP_UEPresence.h"
#include "NGAP_UEPresenceInAreaOfInterestItem.h"
#include "NGAP_UEPresenceInAreaOfInterestList.h"
#include "NGAP_UERadioCapabilityCheckRequest.h"
#include "NGAP_UERadioCapabilityCheckResponse.h"
#include "NGAP_UERadioCapabilityForPaging.h"
#include "NGAP_UERadioCapabilityForPagingOfEUTRA.h"
#include "NGAP_UERadioCapabilityForPagingOfNB-IoT.h"
#include "NGAP_UERadioCapabilityForPagingOfNR.h"
#include "NGAP_UERadioCapability.h"
#include "NGAP_UERadioCapabilityID.h"
#include "NGAP_UERadioCapabilityIDMappingRequest.h"
#include "NGAP_UERadioCapabilityIDMappingResponse.h"
#include "NGAP_UERadioCapabilityInfoIndication.h"
#include "NGAP_UERetentionInformation.h"
#include "NGAP_UERLFReportContainer.h"
#include "NGAP_UESecurityCapabilities.h"
#include "NGAP_UESliceMaximumBitRateItem.h"
#include "NGAP_UESliceMaximumBitRateList.h"
#include "NGAP_UETNLABindingReleaseRequest.h"
#include "NGAP_UE-UP-CIoT-Support.h"
#include "NGAP_UL-CP-SecurityInformation.h"
#include "NGAP_ULForwarding.h"
#include "NGAP_UL-NAS-Count.h"
#include "NGAP_UL-NAS-MAC.h"
#include "NGAP_UL-NGU-UP-TNLModifyItem.h"
#include "NGAP_UL-NGU-UP-TNLModifyList.h"
#include "NGAP_UnavailableGUAMIItem.h"
#include "NGAP_UnavailableGUAMIList.h"
#include "NGAP_UnsuccessfulOutcome.h"
#include "NGAP_UpdateFeedback.h"
#include "NGAP_UplinkNASTransport.h"
#include "NGAP_UplinkNonUEAssociatedNRPPaTransport.h"
#include "NGAP_UplinkRANConfigurationTransfer.h"
#include "NGAP_UplinkRANEarlyStatusTransfer.h"
#include "NGAP_UplinkRANStatusTransfer.h"
#include "NGAP_UplinkRIMInformationTransfer.h"
#include "NGAP_UplinkUEAssociatedNRPPaTransport.h"
#include "NGAP_UPTransportLayerInformation.h"
#include "NGAP_UPTransportLayerInformationItem.h"
#include "NGAP_UPTransportLayerInformationList.h"
#include "NGAP_UPTransportLayerInformationPairItem.h"
#include "NGAP_UPTransportLayerInformationPairList.h"
#include "NGAP_URI-address.h"
#include "NGAP_UserLocationInformationEUTRA.h"
#include "NGAP_UserLocationInformation.h"
#include "NGAP_UserLocationInformationN3IWF.h"
#include "NGAP_UserLocationInformationNR.h"
#include "NGAP_UserLocationInformationTNGF.h"
#include "NGAP_UserLocationInformationTWIF.h"
#include "NGAP_UserLocationInformationW-AGF.h"
#include "NGAP_UserPlaneSecurityInformation.h"
#include "NGAP_VehicleUE.h"
#include "NGAP_VolumeTimedReport-Item.h"
#include "NGAP_VolumeTimedReportList.h"
#include "NGAP_W-AGF-ID.h"
#include "NGAP_WarningAreaCoordinates.h"
#include "NGAP_WarningAreaList.h"
#include "NGAP_WarningMessageContents.h"
#include "NGAP_WarningSecurityInfo.h"
#include "NGAP_WarningType.h"
#include "NGAP_WLANMeasConfig.h"
#include "NGAP_WLANMeasConfigNameItem.h"
#include "NGAP_WLANMeasConfigNameList.h"
#include "NGAP_WLANMeasurementConfiguration.h"
#include "NGAP_WLANName.h"
#include "NGAP_WriteReplaceWarningRequest.h"
#include "NGAP_WriteReplaceWarningResponse.h"
#include "NGAP_WUS-Assistance-Information.h"
#include "NGAP_XnExtTLA-Item.h"
#include "NGAP_XnExtTLAs.h"
#include "NGAP_XnGTP-TLAs.h"
#include "NGAP_XnTLAs.h"
#include "NGAP_XnTNLConfigurationInfo.h"


#include "asn1c/util/conv.h"
#include "asn1c/util/message.h"

#define OGS_NGAP_INSIDE

#include "ngap/conv.h"
#include "ngap/message.h"
#include "ngap/build.h"

#undef OGS_NGAP_INSIDE

#ifdef __cplusplus
extern "C" {
#endif

extern int __ogs_ngap_domain;

#undef OGS_LOG_DOMAIN
#define OGS_LOG_DOMAIN __ogs_ngap_domain

#ifdef __cplusplus
}
#endif

#endif
