Interactive CLI
===============

[`osmo-s1gw-cli.py`](contrib/osmo-s1gw-cli.py) is an interactive shell based on
Python's **cmd2** library.  This script serves as an alternative to the traditional
telnet/VTY interface found in many Osmocom projects.  It communicates with the main
process via the **REST interface**, allowing users to inspect and interact with
OsmoS1GW in a familiar CLI style.

Installation
------------

`osmo-s1gw-cli.py` has the following dependencies:

* [`cmd2`](https://pypi.org/project/cmd2/)
* [`tabulate`](https://pypi.org/project/tabulate/)

You can install them using **pip**:

```bash
pip install cmd2 tabulate
```

Or using your system's package manager (Debian/Ubuntu example):

```bash
sudo apt install python3-cmd2 python3-tabulate
```

Usage
-----

By default, `osmo-s1gw-cli.py` is sending HTTP requests to `http://localhost:8080`.
The hostname/address and port can be specified using command-line arguments:

```bash
./contrib/osmo-s1gw-cli.py --help
usage: osmo-s1gw-cli [-h] [-v] [-p PORT] [HOST]

Interactive CLI for OsmoS1GW

positional arguments:
  HOST             OsmoS1GW REST host/address (default: localhost)

options:
  -h, --help       show this help message and exit
  -v, --verbose    print debug logging
  -p, --port PORT  OsmoS1GW REST port (default: 8080)
```

Available commands can be listed by entering `help -v`:

```
Welcome to Interactive CLI for OsmoS1GW!
OsmoS1GW# help -v
...
```

Each command has its own detailed help, accessible with `help CMD`:

```
OsmoS1GW# help quit
Usage: quit [-h]

Exit this application

optional arguments:
  -h, --help  show this help message and exit
```

In addition to tab-completion, you can filter (`CMD | grep ...`) and/or
redirect (`CMD > FILE`) output of a command to a file.  For more details
on the available features and usage patterns, please refer to the
[cmd2 documentation](https://cmd2.readthedocs.io/en/stable/features/).

Commands
--------

Below is a list of currently supported commands and some examples.

### `fetch_openapi_spec`

Fetch the OpenAPI specification (JSON), dump as text.
