osmo-s1gw
=========

This is an S1AP (S1 Application Protocol) Gateway implementation in Erlang for
the 3GPP EPC (Evolved Packet Core) based (4G/LTE) networks.  It is part of the
[Osmocom](https://osmocom.org/) Open Source Mobile Communications project.

S1AP is a protocol "spoken" between the eNB and the MME.  The S1GW is useful in
scenarios when eNB(s) and the MME co-exist in separate networks and thus unable
to access each other directly.  This is basically a proxy, accepting incoming
connections from eNB(s), establishing the associated outgoing connections
to the MME, and forwarding S1AP PDUs back and forth.

```
          (network A) |
                      |
               +-------------+     +-------------+
               |  osmo-s1gw  |     |     MME     |
+--------+     +-------------+     +-------------+
| eNB(1) | --> |             | --> |             |
+--------+     |             |     |             |
               |             |     |             |
+--------+     |             |     |             |
| eNB(2) | --> |             | --> |             |
+--------+     |             |     |             |
               |             |     |             |
+--------+     |             |     |             |
| eNB(N) | --> |             | --> |             |
+--------+     +-------------+     +-------------+
                      |
                      | (network B)
```


Homepage
--------

This project does not have its own homepage yet, unlike many other
[Osmocom projects](https://osmocom.org/projects/).


GIT Repository
--------------

You can clone from the official osmo-s1gw.git repository using

```
$ git clone https://gitea.osmocom.org/erlang/osmo-s1gw
```

There is a web interface at <https://gitea.osmocom.org/erlang/osmo-s1gw>


Documentation
-------------

Once the project reaches a usable milestone, we will be working on a
user manual.  Stay tuned.


Contributing
------------

Our coding standards are described at
<https://osmocom.org/projects/cellular-infrastructure/wiki/Coding_standards>.

We use a Gerrit based patch submission/review process for managing
contributions.  Please see
<https://osmocom.org/projects/cellular-infrastructure/wiki/Gerrit> for
more details.

The current patch queue for osmo-s1gw can be seen at
<https://gerrit.osmocom.org/#/q/project:erlang/osmo-s1gw+status:open>.


Building
--------

Install erlang and rebar3 packages (not "rebar", that's version 2! You may need
to compile it from source in some distros).

```
$ make
```


Testing
-------

Unit tests can be run this way:

```
$ make check
```


Running
-------

Once `osmo_s1gw` is built, you can start it this way:

```
$ make run
```


Configuration
-------------

The default configuration can be found in
[config/sys.config](config/sys.config).

The existing parameters can be represented as follows:

```
  eNB              S1GW
+-----+     +----------------+
| ... | --> | s1gw_bind_addr |             MME
+-----+     +----------------+     +-----------------+
            |  mme_loc_addr  | --> |  mme_rem_addr   |
            +----------------+     +-----------------+
```

* `s1gw_bind_addr` - S1GW bind address for incoming eNB connections
* `mme_loc_addr` - local address for outgoing connections to the MME
* `mme_rem_addr` - remote address for outgoing connections to the MME

Logging can be configured in the `kernel` section:

* `{logger_level, info}` - logging level (one of `emergency | alert |
                           critical | error | warning | notice |
                           info | debug`)
* `#{formatter => { ... }` - logging formatting configuration
